(ns volga-firebird.unit.common.http-response-code)

(def ^:private default-unexceptional-statuses
  #{200 201 202 203 204 205 206 207 300 301 302 303 304 307})

(defn- ->set [valid-response-codes]
  (loop [sc (first valid-response-codes) scs (rest valid-response-codes) acc #{}]
    (if sc
      (recur (first scs) (rest scs)
             (cond
               (number? sc) (conj acc sc)
               (vector? sc) (apply conj acc (range (first sc)
                                                   (second sc)))))
      acc)))

(defn unexceptional? [status valid-response-codes]
  (boolean ((or (not-empty (->set valid-response-codes))
                default-unexceptional-statuses)
            status)))
