(ns volga-firebird.specs.pipeline
  (:require [clojure.spec.alpha :as s]
            [spec-tools.spec :as spec]
            [volga-firebird.specs.transformation-unit :as t-unit]
            [volga-firebird.specs.rest-unit :as rest-unit]
            [volga-firebird.specs.soap-unit :as soap-unit]
            [volga-firebird.specs.secure-store :as secure-store]
            [volga-firebird.specs.middleware :as m]))

(s/def ::name (s/or :keyword spec/keyword?
                    :string  spec/string?))

(s/def ::non-terminal-inputs (s/coll-of ::unit :into [] :distinct true))

(s/def ::terminal-inputs (s/or :no-reference spec/empty?
                               :with-reference (s/coll-of #{:request} :into [] :min-count 1 :max-count 1)))

(s/def ::inputs (s/or :terminal ::terminal-inputs
                      :non-terminal ::non-terminal-inputs))

(s/def ::middleware (s/coll-of ::m/middleware :into []))

(s/def ::transformation-unit (s/keys :req-un [::name ::inputs ::t-unit/config]
                                     :opt-un [::middleware]))

(s/def ::rest-unit (s/keys :req-un [::name ::inputs ::rest-unit/config]
                           :opt-un [::middleware]))

(s/def ::soap-unit (s/keys :req-un [::name ::inputs ::soap-unit/config]
                           :opt-un [::middleware]))

(s/def ::secure-store (s/keys :req-un [::name ::inputs ::secure-store/config]
                              :opt-un [::middleware]))

(s/def ::unit (s/or :transformation-unit ::transformation-unit
                    :soap-unit           ::soap-unit
                    :rest-unit           ::rest-unit
                    :secure-store        ::secure-store
                    :reference           spec/keyword?))

(s/def ::pipeline ::transformation-unit)
