/*
 * Decompiled with CFR 0.152.
 */
package io.xorc.oam;

import java.math.BigDecimal;
import java.math.BigInteger;

public class Numbers {
    static final LongOps LONG_OPS = new LongOps();
    static final DoubleOps DOUBLE_OPS = new DoubleOps();
    static final BigDecimalOps BIGDECIMAL_OPS = new BigDecimalOps();

    public static boolean isZero(Object x) {
        return Numbers.ops(x).isZero((Number)x);
    }

    public static boolean isPos(Object x) {
        return Numbers.ops(x).isPos((Number)x);
    }

    public static boolean isNeg(Object x) {
        return Numbers.ops(x).isNeg((Number)x);
    }

    public static Number minus(Object x) {
        return Numbers.ops(x).negate((Number)x);
    }

    public static Number minusP(Object x) {
        return Numbers.ops(x).negateP((Number)x);
    }

    public static Number inc(Object x) {
        return Numbers.ops(x).inc((Number)x);
    }

    public static Number incP(Object x) {
        return Numbers.ops(x).incP((Number)x);
    }

    public static Number dec(Object x) {
        return Numbers.ops(x).dec((Number)x);
    }

    public static Number decP(Object x) {
        return Numbers.ops(x).decP((Number)x);
    }

    public static Number add(Object x, Object y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).add((Number)x, (Number)y);
    }

    public static Number addP(Object x, Object y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).addP((Number)x, (Number)y);
    }

    public static Number minus(Object x, Object y) {
        Ops yops = Numbers.ops(y);
        return Numbers.ops(x).combine(yops).add((Number)x, yops.negate((Number)y));
    }

    public static Number minusP(Object x, Object y) {
        Ops yops = Numbers.ops(y);
        Number negativeY = yops.negateP((Number)y);
        Ops negativeYOps = Numbers.ops(negativeY);
        return Numbers.ops(x).combine(negativeYOps).addP((Number)x, negativeY);
    }

    public static Number multiply(Object x, Object y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).multiply((Number)x, (Number)y);
    }

    public static Number multiplyP(Object x, Object y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).multiplyP((Number)x, (Number)y);
    }

    public static Number divide(Object x, Object y) {
        if (Numbers.isNaN(x)) {
            return (Number)x;
        }
        if (Numbers.isNaN(y)) {
            return (Number)y;
        }
        Ops yops = Numbers.ops(y);
        if (yops.isZero((Number)y)) {
            throw new ArithmeticException("Divide by zero");
        }
        return Numbers.ops(x).combine(yops).divide((Number)x, (Number)y);
    }

    public static Number quotient(Object x, Object y) {
        Ops yops = Numbers.ops(y);
        if (yops.isZero((Number)y)) {
            throw new ArithmeticException("Divide by zero");
        }
        return Numbers.ops(x).combine(yops).quotient((Number)x, (Number)y);
    }

    public static Number remainder(Object x, Object y) {
        Ops yops = Numbers.ops(y);
        if (yops.isZero((Number)y)) {
            throw new ArithmeticException("Divide by zero");
        }
        return Numbers.ops(x).combine(yops).remainder((Number)x, (Number)y);
    }

    public static double quotient(double n, double d) {
        if (d == 0.0) {
            throw new ArithmeticException("Divide by zero");
        }
        double q = n / d;
        if (q <= 9.223372036854776E18 && q >= -9.223372036854776E18) {
            return (long)q;
        }
        return new BigDecimal(q).toBigInteger().doubleValue();
    }

    public static double remainder(double n, double d) {
        if (d == 0.0) {
            throw new ArithmeticException("Divide by zero");
        }
        double q = n / d;
        if (q <= 9.223372036854776E18 && q >= -9.223372036854776E18) {
            return n - (double)((long)q) * d;
        }
        BigInteger bq = new BigDecimal(q).toBigInteger();
        return n - ((Number)bq).doubleValue() * d;
    }

    public static boolean equiv(Object x, Object y) {
        return Numbers.equiv((Number)x, (Number)y);
    }

    public static boolean equiv(Number x, Number y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).equiv(x, y);
    }

    public static boolean equal(Number x, Number y) {
        return Numbers.category(x) == Numbers.category(y) && Numbers.ops(x).combine(Numbers.ops(y)).equiv(x, y);
    }

    public static boolean lt(Object x, Object y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).lt((Number)x, (Number)y);
    }

    public static boolean lte(Object x, Object y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).lte((Number)x, (Number)y);
    }

    public static boolean gt(Object x, Object y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).lt((Number)y, (Number)x);
    }

    public static boolean gte(Object x, Object y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).gte((Number)x, (Number)y);
    }

    public static int compare(Number x, Number y) {
        Ops ops = Numbers.ops(x).combine(Numbers.ops(y));
        if (ops.lt(x, y)) {
            return -1;
        }
        if (ops.lt(y, x)) {
            return 1;
        }
        return 0;
    }

    static BigInteger toBigInteger(Object x) {
        if (x instanceof BigInteger) {
            return (BigInteger)x;
        }
        return BigInteger.valueOf(((Number)x).longValue());
    }

    static BigDecimal toBigDecimal(Object x) {
        if (x instanceof BigDecimal) {
            return (BigDecimal)x;
        }
        if (x instanceof BigInteger) {
            return new BigDecimal((BigInteger)x);
        }
        if (x instanceof Double) {
            return new BigDecimal(((Number)x).doubleValue());
        }
        if (x instanceof Float) {
            return new BigDecimal(((Number)x).doubleValue());
        }
        return BigDecimal.valueOf(((Number)x).longValue());
    }

    public static Number rationalize(Number x) {
        if (x instanceof Float || x instanceof Double) {
            return Numbers.rationalize(BigDecimal.valueOf(x.doubleValue()));
        }
        if (x instanceof BigDecimal) {
            BigDecimal bx = (BigDecimal)x;
            BigInteger bv = bx.unscaledValue();
            int scale = bx.scale();
            return Numbers.divide(bv, BigInteger.TEN.pow(scale));
        }
        return x;
    }

    public static Number divide(BigInteger n, BigInteger d) {
        if (d.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Divide by zero");
        }
        BigInteger gcd = n.gcd(d);
        if (gcd.equals(BigInteger.ZERO)) {
            return BigInteger.ZERO;
        }
        n = n.divide(gcd);
        if ((d = d.divide(gcd)).equals(BigInteger.ONE)) {
            return n;
        }
        if (d.equals(BigInteger.ONE.negate())) {
            return n.negate();
        }
        return (d.signum() < 0 ? n.negate() : n).doubleValue() / (d.signum() < 0 ? d.negate() : d).doubleValue();
    }

    static Ops ops(Object x) {
        Class<?> xc = x.getClass();
        if (xc == Long.class) {
            return LONG_OPS;
        }
        if (xc == Double.class) {
            return DOUBLE_OPS;
        }
        if (xc == Integer.class) {
            return LONG_OPS;
        }
        if (xc == Float.class) {
            return DOUBLE_OPS;
        }
        if (xc == BigDecimal.class) {
            return BIGDECIMAL_OPS;
        }
        return LONG_OPS;
    }

    static Category category(Object x) {
        Class<?> xc = x.getClass();
        if (xc == Integer.class) {
            return Category.INTEGER;
        }
        if (xc == Double.class) {
            return Category.FLOATING;
        }
        if (xc == Long.class) {
            return Category.INTEGER;
        }
        if (xc == Float.class) {
            return Category.FLOATING;
        }
        if (xc == BigDecimal.class) {
            return Category.DECIMAL;
        }
        return Category.INTEGER;
    }

    public static Number num(Object x) {
        return (Number)x;
    }

    public static Number num(float x) {
        return Float.valueOf(x);
    }

    public static Number num(double x) {
        return x;
    }

    public static double add(double x, double y) {
        return x + y;
    }

    public static double addP(double x, double y) {
        return x + y;
    }

    public static double minus(double x, double y) {
        return x - y;
    }

    public static double minusP(double x, double y) {
        return x - y;
    }

    public static double minus(double x) {
        return -x;
    }

    public static double minusP(double x) {
        return -x;
    }

    public static double inc(double x) {
        return x + 1.0;
    }

    public static double incP(double x) {
        return x + 1.0;
    }

    public static double dec(double x) {
        return x - 1.0;
    }

    public static double decP(double x) {
        return x - 1.0;
    }

    public static double multiply(double x, double y) {
        return x * y;
    }

    public static double multiplyP(double x, double y) {
        return x * y;
    }

    public static double divide(double x, double y) {
        return x / y;
    }

    public static boolean equiv(double x, double y) {
        return x == y;
    }

    public static boolean lt(double x, double y) {
        return x < y;
    }

    public static boolean lte(double x, double y) {
        return x <= y;
    }

    public static boolean gt(double x, double y) {
        return x > y;
    }

    public static boolean gte(double x, double y) {
        return x >= y;
    }

    public static boolean isPos(double x) {
        return x > 0.0;
    }

    public static boolean isNeg(double x) {
        return x < 0.0;
    }

    public static boolean isZero(double x) {
        return x == 0.0;
    }

    static int throwIntOverflow() {
        throw new ArithmeticException("integer overflow");
    }

    public static int unchecked_int_add(int x, int y) {
        return x + y;
    }

    public static int unchecked_int_subtract(int x, int y) {
        return x - y;
    }

    public static int unchecked_int_negate(int x) {
        return -x;
    }

    public static int unchecked_int_inc(int x) {
        return x + 1;
    }

    public static int unchecked_int_dec(int x) {
        return x - 1;
    }

    public static int unchecked_int_multiply(int x, int y) {
        return x * y;
    }

    public static int unchecked_int_divide(int x, int y) {
        return x / y;
    }

    public static int unchecked_int_remainder(int x, int y) {
        return x % y;
    }

    public static Number num(long x) {
        return x;
    }

    public static long unchecked_add(long x, long y) {
        return x + y;
    }

    public static long unchecked_minus(long x, long y) {
        return x - y;
    }

    public static long unchecked_multiply(long x, long y) {
        return x * y;
    }

    public static long unchecked_minus(long x) {
        return -x;
    }

    public static long unchecked_inc(long x) {
        return x + 1L;
    }

    public static long unchecked_dec(long x) {
        return x - 1L;
    }

    public static Number unchecked_add(Object x, Object y) {
        return Numbers.add(x, y);
    }

    public static Number unchecked_minus(Object x, Object y) {
        return Numbers.minus(x, y);
    }

    public static Number unchecked_multiply(Object x, Object y) {
        return Numbers.multiply(x, y);
    }

    public static Number unchecked_minus(Object x) {
        return Numbers.minus(x);
    }

    public static Number unchecked_inc(Object x) {
        return Numbers.inc(x);
    }

    public static Number unchecked_dec(Object x) {
        return Numbers.dec(x);
    }

    public static double unchecked_add(double x, double y) {
        return Numbers.add(x, y);
    }

    public static double unchecked_minus(double x, double y) {
        return Numbers.minus(x, y);
    }

    public static double unchecked_multiply(double x, double y) {
        return Numbers.multiply(x, y);
    }

    public static double unchecked_minus(double x) {
        return Numbers.minus(x);
    }

    public static double unchecked_inc(double x) {
        return Numbers.inc(x);
    }

    public static double unchecked_dec(double x) {
        return Numbers.dec(x);
    }

    public static double unchecked_add(double x, Object y) {
        return Numbers.add(x, y);
    }

    public static double unchecked_minus(double x, Object y) {
        return Numbers.minus(x, y);
    }

    public static double unchecked_multiply(double x, Object y) {
        return Numbers.multiply(x, y);
    }

    public static double unchecked_add(Object x, double y) {
        return Numbers.add(x, y);
    }

    public static double unchecked_minus(Object x, double y) {
        return Numbers.minus(x, y);
    }

    public static double unchecked_multiply(Object x, double y) {
        return Numbers.multiply(x, y);
    }

    public static double unchecked_add(double x, long y) {
        return Numbers.add(x, y);
    }

    public static double unchecked_minus(double x, long y) {
        return Numbers.minus(x, y);
    }

    public static double unchecked_multiply(double x, long y) {
        return Numbers.multiply(x, y);
    }

    public static double unchecked_add(long x, double y) {
        return Numbers.add(x, y);
    }

    public static double unchecked_minus(long x, double y) {
        return Numbers.minus(x, y);
    }

    public static double unchecked_multiply(long x, double y) {
        return Numbers.multiply(x, y);
    }

    public static Number unchecked_add(long x, Object y) {
        return Numbers.add(x, y);
    }

    public static Number unchecked_minus(long x, Object y) {
        return Numbers.minus(x, y);
    }

    public static Number unchecked_multiply(long x, Object y) {
        return Numbers.multiply(x, y);
    }

    public static Number unchecked_add(Object x, long y) {
        return Numbers.add(x, y);
    }

    public static Number unchecked_minus(Object x, long y) {
        return Numbers.minus(x, y);
    }

    public static Number unchecked_multiply(Object x, long y) {
        return Numbers.multiply(x, y);
    }

    public static Number quotient(double x, Object y) {
        return Numbers.quotient((Object)x, y);
    }

    public static Number quotient(Object x, double y) {
        return Numbers.quotient(x, (Object)y);
    }

    public static Number quotient(long x, Object y) {
        return Numbers.quotient((Object)x, y);
    }

    public static Number quotient(Object x, long y) {
        return Numbers.quotient(x, (Object)y);
    }

    public static double quotient(double x, long y) {
        return Numbers.quotient(x, (double)y);
    }

    public static double quotient(long x, double y) {
        return Numbers.quotient((double)x, y);
    }

    public static Number remainder(double x, Object y) {
        return Numbers.remainder((Object)x, y);
    }

    public static Number remainder(Object x, double y) {
        return Numbers.remainder(x, (Object)y);
    }

    public static Number remainder(long x, Object y) {
        return Numbers.remainder((Object)x, y);
    }

    public static Number remainder(Object x, long y) {
        return Numbers.remainder(x, (Object)y);
    }

    public static double remainder(double x, long y) {
        return Numbers.remainder(x, (double)y);
    }

    public static double remainder(long x, double y) {
        return Numbers.remainder((double)x, y);
    }

    public static long add(long x, long y) {
        long ret = x + y;
        if ((ret ^ x) < 0L && (ret ^ y) < 0L) {
            return Numbers.throwIntOverflow();
        }
        return ret;
    }

    public static Number addP(long x, long y) {
        long ret = x + y;
        if ((ret ^ x) < 0L && (ret ^ y) < 0L) {
            return Numbers.addP((Object)x, (Object)y);
        }
        return Numbers.num(ret);
    }

    public static long minus(long x, long y) {
        long ret = x - y;
        if ((ret ^ x) < 0L && (ret ^ (y ^ 0xFFFFFFFFFFFFFFFFL)) < 0L) {
            return Numbers.throwIntOverflow();
        }
        return ret;
    }

    public static Number minusP(long x, long y) {
        long ret = x - y;
        if ((ret ^ x) < 0L && (ret ^ (y ^ 0xFFFFFFFFFFFFFFFFL)) < 0L) {
            return Numbers.minusP((Object)x, (Object)y);
        }
        return Numbers.num(ret);
    }

    public static long minus(long x) {
        if (x == Long.MIN_VALUE) {
            return Numbers.throwIntOverflow();
        }
        return -x;
    }

    public static Number minusP(long x) {
        if (x == Long.MIN_VALUE) {
            return BigInteger.valueOf(x).negate();
        }
        return Numbers.num(-x);
    }

    public static long inc(long x) {
        if (x == Long.MAX_VALUE) {
            return Numbers.throwIntOverflow();
        }
        return x + 1L;
    }

    public static Number incP(long x) {
        if (x == Long.MAX_VALUE) {
            return DOUBLE_OPS.inc(x);
        }
        return Numbers.num(x + 1L);
    }

    public static long dec(long x) {
        if (x == Long.MIN_VALUE) {
            return Numbers.throwIntOverflow();
        }
        return x - 1L;
    }

    public static Number decP(long x) {
        if (x == Long.MIN_VALUE) {
            return DOUBLE_OPS.dec(x);
        }
        return Numbers.num(x - 1L);
    }

    public static long multiply(long x, long y) {
        if (x == Long.MIN_VALUE && y < 0L) {
            return Numbers.throwIntOverflow();
        }
        long ret = x * y;
        if (y != 0L && ret / y != x) {
            return Numbers.throwIntOverflow();
        }
        return ret;
    }

    public static Number multiplyP(long x, long y) {
        if (x == Long.MIN_VALUE && y < 0L) {
            return Numbers.multiplyP((Object)x, (Object)y);
        }
        long ret = x * y;
        if (y != 0L && ret / y != x) {
            return Numbers.multiplyP((Object)x, (Object)y);
        }
        return Numbers.num(ret);
    }

    public static long quotient(long x, long y) {
        return x / y;
    }

    public static long remainder(long x, long y) {
        return x % y;
    }

    public static boolean equiv(long x, long y) {
        return x == y;
    }

    public static boolean lt(long x, long y) {
        return x < y;
    }

    public static boolean lte(long x, long y) {
        return x <= y;
    }

    public static boolean gt(long x, long y) {
        return x > y;
    }

    public static boolean gte(long x, long y) {
        return x >= y;
    }

    public static boolean isPos(long x) {
        return x > 0L;
    }

    public static boolean isNeg(long x) {
        return x < 0L;
    }

    public static boolean isZero(long x) {
        return x == 0L;
    }

    public static Number add(long x, Object y) {
        return Numbers.add((Object)x, y);
    }

    public static Number add(Object x, long y) {
        return Numbers.add(x, (Object)y);
    }

    public static Number addP(long x, Object y) {
        return Numbers.addP((Object)x, y);
    }

    public static Number addP(Object x, long y) {
        return Numbers.addP(x, (Object)y);
    }

    public static double add(double x, Object y) {
        return Numbers.add(x, ((Number)y).doubleValue());
    }

    public static double add(Object x, double y) {
        return Numbers.add(((Number)x).doubleValue(), y);
    }

    public static double add(double x, long y) {
        return x + (double)y;
    }

    public static double add(long x, double y) {
        return (double)x + y;
    }

    public static double addP(double x, Object y) {
        return Numbers.addP(x, ((Number)y).doubleValue());
    }

    public static double addP(Object x, double y) {
        return Numbers.addP(((Number)x).doubleValue(), y);
    }

    public static double addP(double x, long y) {
        return x + (double)y;
    }

    public static double addP(long x, double y) {
        return (double)x + y;
    }

    public static Number minus(long x, Object y) {
        return Numbers.minus((Object)x, y);
    }

    public static Number minus(Object x, long y) {
        return Numbers.minus(x, (Object)y);
    }

    public static Number minusP(long x, Object y) {
        return Numbers.minusP((Object)x, y);
    }

    public static Number minusP(Object x, long y) {
        return Numbers.minusP(x, (Object)y);
    }

    public static double minus(double x, Object y) {
        return Numbers.minus(x, ((Number)y).doubleValue());
    }

    public static double minus(Object x, double y) {
        return Numbers.minus(((Number)x).doubleValue(), y);
    }

    public static double minus(double x, long y) {
        return x - (double)y;
    }

    public static double minus(long x, double y) {
        return (double)x - y;
    }

    public static double minusP(double x, Object y) {
        return Numbers.minus(x, ((Number)y).doubleValue());
    }

    public static double minusP(Object x, double y) {
        return Numbers.minus(((Number)x).doubleValue(), y);
    }

    public static double minusP(double x, long y) {
        return x - (double)y;
    }

    public static double minusP(long x, double y) {
        return (double)x - y;
    }

    public static Number multiply(long x, Object y) {
        return Numbers.multiply((Object)x, y);
    }

    public static Number multiply(Object x, long y) {
        return Numbers.multiply(x, (Object)y);
    }

    public static Number multiplyP(long x, Object y) {
        return Numbers.multiplyP((Object)x, y);
    }

    public static Number multiplyP(Object x, long y) {
        return Numbers.multiplyP(x, (Object)y);
    }

    public static double multiply(double x, Object y) {
        return Numbers.multiply(x, ((Number)y).doubleValue());
    }

    public static double multiply(Object x, double y) {
        return Numbers.multiply(((Number)x).doubleValue(), y);
    }

    public static double multiply(double x, long y) {
        return x * (double)y;
    }

    public static double multiply(long x, double y) {
        return (double)x * y;
    }

    public static double multiplyP(double x, Object y) {
        return Numbers.multiplyP(x, ((Number)y).doubleValue());
    }

    public static double multiplyP(Object x, double y) {
        return Numbers.multiplyP(((Number)x).doubleValue(), y);
    }

    public static double multiplyP(double x, long y) {
        return x * (double)y;
    }

    public static double multiplyP(long x, double y) {
        return (double)x * y;
    }

    public static Number divide(long x, Object y) {
        return Numbers.divide((Object)x, y);
    }

    public static Number divide(Object x, long y) {
        return Numbers.divide(x, (Object)y);
    }

    public static double divide(double x, Object y) {
        return x / ((Number)y).doubleValue();
    }

    public static double divide(Object x, double y) {
        return ((Number)x).doubleValue() / y;
    }

    public static double divide(double x, long y) {
        return x / (double)y;
    }

    public static double divide(long x, double y) {
        return (double)x / y;
    }

    public static Number divide(long x, long y) {
        return Numbers.divide((Object)x, (Object)y);
    }

    public static boolean lt(long x, Object y) {
        return Numbers.lt((Object)x, y);
    }

    public static boolean lt(Object x, long y) {
        return Numbers.lt(x, (Object)y);
    }

    public static boolean lt(double x, Object y) {
        return x < ((Number)y).doubleValue();
    }

    public static boolean lt(Object x, double y) {
        return ((Number)x).doubleValue() < y;
    }

    public static boolean lt(double x, long y) {
        return x < (double)y;
    }

    public static boolean lt(long x, double y) {
        return (double)x < y;
    }

    public static boolean lte(long x, Object y) {
        return Numbers.lte((Object)x, y);
    }

    public static boolean lte(Object x, long y) {
        return Numbers.lte(x, (Object)y);
    }

    public static boolean lte(double x, Object y) {
        return x <= ((Number)y).doubleValue();
    }

    public static boolean lte(Object x, double y) {
        return ((Number)x).doubleValue() <= y;
    }

    public static boolean lte(double x, long y) {
        return x <= (double)y;
    }

    public static boolean lte(long x, double y) {
        return (double)x <= y;
    }

    public static boolean gt(long x, Object y) {
        return Numbers.gt((Object)x, y);
    }

    public static boolean gt(Object x, long y) {
        return Numbers.gt(x, (Object)y);
    }

    public static boolean gt(double x, Object y) {
        return x > ((Number)y).doubleValue();
    }

    public static boolean gt(Object x, double y) {
        return ((Number)x).doubleValue() > y;
    }

    public static boolean gt(double x, long y) {
        return x > (double)y;
    }

    public static boolean gt(long x, double y) {
        return (double)x > y;
    }

    public static boolean gte(long x, Object y) {
        return Numbers.gte((Object)x, y);
    }

    public static boolean gte(Object x, long y) {
        return Numbers.gte(x, (Object)y);
    }

    public static boolean gte(double x, Object y) {
        return x >= ((Number)y).doubleValue();
    }

    public static boolean gte(Object x, double y) {
        return ((Number)x).doubleValue() >= y;
    }

    public static boolean gte(double x, long y) {
        return x >= (double)y;
    }

    public static boolean gte(long x, double y) {
        return (double)x >= y;
    }

    public static boolean equiv(long x, Object y) {
        return Numbers.equiv((Object)x, y);
    }

    public static boolean equiv(Object x, long y) {
        return Numbers.equiv(x, (Object)y);
    }

    public static boolean equiv(double x, Object y) {
        return x == ((Number)y).doubleValue();
    }

    public static boolean equiv(Object x, double y) {
        return ((Number)x).doubleValue() == y;
    }

    public static boolean equiv(double x, long y) {
        return x == (double)y;
    }

    public static boolean equiv(long x, double y) {
        return (double)x == y;
    }

    static boolean isNaN(Object x) {
        return x instanceof Double && ((Double)x).isNaN() || x instanceof Float && ((Float)x).isNaN();
    }

    public static double max(double x, double y) {
        return Math.max(x, y);
    }

    public static Object max(double x, long y) {
        if (Double.isNaN(x)) {
            return x;
        }
        if (x > (double)y) {
            return x;
        }
        return y;
    }

    public static Object max(double x, Object y) {
        if (Double.isNaN(x)) {
            return x;
        }
        if (Numbers.isNaN(y)) {
            return y;
        }
        if (x > ((Number)y).doubleValue()) {
            return x;
        }
        return y;
    }

    public static Object max(long x, double y) {
        if (Double.isNaN(y)) {
            return y;
        }
        if ((double)x > y) {
            return x;
        }
        return y;
    }

    public static long max(long x, long y) {
        if (x > y) {
            return x;
        }
        return y;
    }

    public static Object max(long x, Object y) {
        if (Numbers.isNaN(y)) {
            return y;
        }
        if (Numbers.gt(x, y)) {
            return x;
        }
        return y;
    }

    public static Object max(Object x, long y) {
        if (Numbers.isNaN(x)) {
            return x;
        }
        if (Numbers.gt(x, y)) {
            return x;
        }
        return y;
    }

    public static Object max(Object x, double y) {
        if (Numbers.isNaN(x)) {
            return x;
        }
        if (Double.isNaN(y)) {
            return y;
        }
        if (((Number)x).doubleValue() > y) {
            return x;
        }
        return y;
    }

    public static Object max(Object x, Object y) {
        if (Numbers.isNaN(x)) {
            return x;
        }
        if (Numbers.isNaN(y)) {
            return y;
        }
        if (Numbers.gt(x, y)) {
            return x;
        }
        return y;
    }

    public static double min(double x, double y) {
        return Math.min(x, y);
    }

    public static Object min(double x, long y) {
        if (Double.isNaN(x)) {
            return x;
        }
        if (x < (double)y) {
            return x;
        }
        return y;
    }

    public static Object min(double x, Object y) {
        if (Double.isNaN(x)) {
            return x;
        }
        if (Numbers.isNaN(y)) {
            return y;
        }
        if (x < ((Number)y).doubleValue()) {
            return x;
        }
        return y;
    }

    public static Object min(long x, double y) {
        if (Double.isNaN(y)) {
            return y;
        }
        if ((double)x < y) {
            return x;
        }
        return y;
    }

    public static long min(long x, long y) {
        if (x < y) {
            return x;
        }
        return y;
    }

    public static Object min(long x, Object y) {
        if (Numbers.isNaN(y)) {
            return y;
        }
        if (Numbers.lt(x, y)) {
            return x;
        }
        return y;
    }

    public static Object min(Object x, long y) {
        if (Numbers.isNaN(x)) {
            return x;
        }
        if (Numbers.lt(x, y)) {
            return x;
        }
        return y;
    }

    public static Object min(Object x, double y) {
        if (Numbers.isNaN(x)) {
            return x;
        }
        if (Double.isNaN(y)) {
            return y;
        }
        if (((Number)x).doubleValue() < y) {
            return x;
        }
        return y;
    }

    public static Object min(Object x, Object y) {
        if (Numbers.isNaN(x)) {
            return x;
        }
        if (Numbers.isNaN(y)) {
            return y;
        }
        if (Numbers.lt(x, y)) {
            return x;
        }
        return y;
    }

    public static enum Category {
        INTEGER,
        FLOATING,
        DECIMAL,
        RATIO;

    }

    static final class BigDecimalOps
    extends OpsP {
        BigDecimalOps() {
        }

        @Override
        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        @Override
        public final Ops opsWith(LongOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        @Override
        public final Ops opsWith(BigDecimalOps x) {
            return this;
        }

        @Override
        public boolean isZero(Number x) {
            BigDecimal bx = (BigDecimal)x;
            return bx.signum() == 0;
        }

        @Override
        public boolean isPos(Number x) {
            BigDecimal bx = (BigDecimal)x;
            return bx.signum() > 0;
        }

        @Override
        public boolean isNeg(Number x) {
            BigDecimal bx = (BigDecimal)x;
            return bx.signum() < 0;
        }

        @Override
        public final Number add(Number x, Number y) {
            return Numbers.toBigDecimal(x).add(Numbers.toBigDecimal(y));
        }

        @Override
        public final Number multiply(Number x, Number y) {
            return Numbers.toBigDecimal(x).multiply(Numbers.toBigDecimal(y));
        }

        @Override
        public Number divide(Number x, Number y) {
            return Numbers.toBigDecimal(x).divide(Numbers.toBigDecimal(y));
        }

        @Override
        public Number quotient(Number x, Number y) {
            return Numbers.toBigDecimal(x).divideToIntegralValue(Numbers.toBigDecimal(y));
        }

        @Override
        public Number remainder(Number x, Number y) {
            return Numbers.toBigDecimal(x).remainder(Numbers.toBigDecimal(y));
        }

        @Override
        public boolean equiv(Number x, Number y) {
            return Numbers.toBigDecimal(x).compareTo(Numbers.toBigDecimal(y)) == 0;
        }

        @Override
        public boolean lt(Number x, Number y) {
            return Numbers.toBigDecimal(x).compareTo(Numbers.toBigDecimal(y)) < 0;
        }

        @Override
        public boolean lte(Number x, Number y) {
            return Numbers.toBigDecimal(x).compareTo(Numbers.toBigDecimal(y)) <= 0;
        }

        @Override
        public boolean gte(Number x, Number y) {
            return Numbers.toBigDecimal(x).compareTo(Numbers.toBigDecimal(y)) >= 0;
        }

        @Override
        public final Number negate(Number x) {
            return ((BigDecimal)x).negate();
        }

        @Override
        public Number inc(Number x) {
            BigDecimal bx = (BigDecimal)x;
            return bx.add(BigDecimal.ONE);
        }

        @Override
        public Number dec(Number x) {
            BigDecimal bx = (BigDecimal)x;
            return bx.subtract(BigDecimal.ONE);
        }
    }

    static final class DoubleOps
    extends OpsP {
        DoubleOps() {
        }

        @Override
        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        @Override
        public final Ops opsWith(LongOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(DoubleOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(BigDecimalOps x) {
            return this;
        }

        @Override
        public boolean isZero(Number x) {
            return x.doubleValue() == 0.0;
        }

        @Override
        public boolean isPos(Number x) {
            return x.doubleValue() > 0.0;
        }

        @Override
        public boolean isNeg(Number x) {
            return x.doubleValue() < 0.0;
        }

        @Override
        public final Number add(Number x, Number y) {
            return x.doubleValue() + y.doubleValue();
        }

        @Override
        public final Number multiply(Number x, Number y) {
            return x.doubleValue() * y.doubleValue();
        }

        @Override
        public Number divide(Number x, Number y) {
            return x.doubleValue() / y.doubleValue();
        }

        @Override
        public Number quotient(Number x, Number y) {
            return Numbers.quotient(x.doubleValue(), y.doubleValue());
        }

        @Override
        public Number remainder(Number x, Number y) {
            return Numbers.remainder(x.doubleValue(), y.doubleValue());
        }

        @Override
        public boolean equiv(Number x, Number y) {
            return x.doubleValue() == y.doubleValue();
        }

        @Override
        public boolean lt(Number x, Number y) {
            return x.doubleValue() < y.doubleValue();
        }

        @Override
        public boolean lte(Number x, Number y) {
            return x.doubleValue() <= y.doubleValue();
        }

        @Override
        public boolean gte(Number x, Number y) {
            return x.doubleValue() >= y.doubleValue();
        }

        @Override
        public final Number negate(Number x) {
            return -x.doubleValue();
        }

        @Override
        public Number inc(Number x) {
            return x.doubleValue() + 1.0;
        }

        @Override
        public Number dec(Number x) {
            return x.doubleValue() - 1.0;
        }
    }

    static final class LongOps
    implements Ops {
        LongOps() {
        }

        @Override
        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        @Override
        public final Ops opsWith(LongOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        @Override
        public final Ops opsWith(BigDecimalOps x) {
            return BIGDECIMAL_OPS;
        }

        @Override
        public boolean isZero(Number x) {
            return x.longValue() == 0L;
        }

        @Override
        public boolean isPos(Number x) {
            return x.longValue() > 0L;
        }

        @Override
        public boolean isNeg(Number x) {
            return x.longValue() < 0L;
        }

        @Override
        public final Number add(Number x, Number y) {
            return Numbers.num(Numbers.add(x.longValue(), y.longValue()));
        }

        @Override
        public final Number addP(Number x, Number y) {
            long ly;
            long lx = x.longValue();
            long ret = lx + (ly = y.longValue());
            if ((ret ^ lx) < 0L && (ret ^ ly) < 0L) {
                return DOUBLE_OPS.add(x, y);
            }
            return Numbers.num(ret);
        }

        @Override
        public final Number multiply(Number x, Number y) {
            return Numbers.num(Numbers.multiply(x.longValue(), y.longValue()));
        }

        @Override
        public final Number multiplyP(Number x, Number y) {
            long lx = x.longValue();
            long ly = y.longValue();
            if (lx == Long.MIN_VALUE && ly < 0L) {
                return DOUBLE_OPS.multiply(x, y);
            }
            long ret = lx * ly;
            if (ly != 0L && ret / ly != lx) {
                return DOUBLE_OPS.multiply(x, y);
            }
            return Numbers.num(ret);
        }

        static long gcd(long u, long v) {
            while (v != 0L) {
                long r = u % v;
                u = v;
                v = r;
            }
            return u;
        }

        @Override
        public Number divide(Number x, Number y) {
            long val;
            long n = x.longValue();
            long gcd = LongOps.gcd(n, val = y.longValue());
            if (gcd == 0L) {
                return Numbers.num(0L);
            }
            n /= gcd;
            long d = val / gcd;
            if (d == 1L) {
                return Numbers.num(n);
            }
            if (d < 0L) {
                n = -n;
                d = -d;
            }
            return (double)n / (double)d;
        }

        @Override
        public Number quotient(Number x, Number y) {
            return Numbers.num(x.longValue() / y.longValue());
        }

        @Override
        public Number remainder(Number x, Number y) {
            return Numbers.num(x.longValue() % y.longValue());
        }

        @Override
        public boolean equiv(Number x, Number y) {
            return x.longValue() == y.longValue();
        }

        @Override
        public boolean lt(Number x, Number y) {
            return x.longValue() < y.longValue();
        }

        @Override
        public boolean lte(Number x, Number y) {
            return x.longValue() <= y.longValue();
        }

        @Override
        public boolean gte(Number x, Number y) {
            return x.longValue() >= y.longValue();
        }

        @Override
        public final Number negate(Number x) {
            long val = x.longValue();
            return Numbers.num(Numbers.minus(val));
        }

        @Override
        public final Number negateP(Number x) {
            long val = x.longValue();
            if (val > Long.MIN_VALUE) {
                return Numbers.num(-val);
            }
            return BigInteger.valueOf(val).negate();
        }

        @Override
        public Number inc(Number x) {
            long val = x.longValue();
            return Numbers.num(Numbers.inc(val));
        }

        @Override
        public Number incP(Number x) {
            long val = x.longValue();
            if (val < Long.MAX_VALUE) {
                return Numbers.num(val + 1L);
            }
            return DOUBLE_OPS.inc(x);
        }

        @Override
        public Number dec(Number x) {
            long val = x.longValue();
            return Numbers.num(Numbers.dec(val));
        }

        @Override
        public Number decP(Number x) {
            long val = x.longValue();
            if (val > Long.MIN_VALUE) {
                return Numbers.num(val - 1L);
            }
            return DOUBLE_OPS.dec(x);
        }
    }

    static abstract class OpsP
    implements Ops {
        OpsP() {
        }

        @Override
        public Number addP(Number x, Number y) {
            return this.add(x, y);
        }

        @Override
        public Number multiplyP(Number x, Number y) {
            return this.multiply(x, y);
        }

        @Override
        public Number negateP(Number x) {
            return this.negate(x);
        }

        @Override
        public Number incP(Number x) {
            return this.inc(x);
        }

        @Override
        public Number decP(Number x) {
            return this.dec(x);
        }
    }

    static interface Ops {
        public Ops combine(Ops var1);

        public Ops opsWith(LongOps var1);

        public Ops opsWith(DoubleOps var1);

        public Ops opsWith(BigDecimalOps var1);

        public boolean isZero(Number var1);

        public boolean isPos(Number var1);

        public boolean isNeg(Number var1);

        public Number add(Number var1, Number var2);

        public Number addP(Number var1, Number var2);

        public Number multiply(Number var1, Number var2);

        public Number multiplyP(Number var1, Number var2);

        public Number divide(Number var1, Number var2);

        public Number quotient(Number var1, Number var2);

        public Number remainder(Number var1, Number var2);

        public boolean equiv(Number var1, Number var2);

        public boolean lt(Number var1, Number var2);

        public boolean lte(Number var1, Number var2);

        public boolean gte(Number var1, Number var2);

        public Number negate(Number var1);

        public Number negateP(Number var1);

        public Number inc(Number var1);

        public Number incP(Number var1);

        public Number dec(Number var1);

        public Number decP(Number var1);
    }
}

