(ns sock.http-kit
  (:require
    [clojure.core.async :refer [<! >! put! close! chan dropping-buffer go-loop]]
    [clojure.edn :as edn]
    [org.httpkit.server :refer :all]))


(defn ws-handler [connection-chan & {:keys [in out err wire-spec]
                                     :or   {in  (chan (dropping-buffer 1024))
                                            out (chan (dropping-buffer 1024))
                                            err (chan (dropping-buffer 1024))
                                            wire-spec
                                                {:name    "application/edn" ;TODO check encoding and throw error on mismatch
                                                 :encoder pr-str
                                                 :decoder edn/read-string}}}]
  (fn [request]
    (with-channel request channel
                  (when (websocket? channel)
                    (on-close channel (fn [status]
                                        (put! err {:event :close
                                                   :origin :remote
                                                   :status status})
                                        (close! in)
                                        (close! err)))
                    (on-receive channel (fn [data]
                                          (put! in ((:decoder wire-spec) data))))
                    (go-loop []
                      (let [data (<! out)]
                        (if data
                          (do (send! channel ((:encoder wire-spec) data))
                              (recur))
                          (close channel))))
                    (put! connection-chan {:in  in
                                           :out out
                                           :err err})))))
