/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.dtk.op.convolution;

import it.uniroma2.dtk.op.convolution.CircularConvolution;
import it.uniroma2.util.vector.VectorComposer;
import java.util.Arrays;

public class ShiftedCircularConvolution
extends CircularConvolution {
    public double[] op(double[] x, double[] y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (this.fft == null) {
            return this.shiftedConvolutionBasic(x, y);
        }
        return this.shiftedConvolutionFFT(x, y);
    }

    public double[] shiftedConvolutionBasic(double[] firstVector, double[] secondVector) {
        int size = firstVector.length;
        double[] result = new double[size];
        Arrays.fill(result, 0.0);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int k = i - j < 0 ? i - j + size : i - j;
                int n = i;
                result[n] = result[n] + firstVector[j] * secondVector[k > 0 ? k - 1 : size - 1];
            }
        }
        return result;
    }

    public double[] shiftedConvolutionFFT(double[] firstVector, double[] secondVector) {
        return this.circularConvolutionFFT(VectorComposer.shift(firstVector), VectorComposer.shift(secondVector));
    }
}

