/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.dtk.op.convolution;

import it.uniroma2.dtk.op.convolution.CircularConvolution;
import it.uniroma2.util.vector.VectorComposer;
import java.util.Arrays;

public class ShuffledCircularConvolution
extends CircularConvolution {
    public double[] op(double[] x, double[] y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (this.fft == null) {
            return this.shuffledConvolutionBasic(x, y);
        }
        return this.shuffledConvolutionFFT(x, y);
    }

    public double[] shuffledConvolutionBasic(double[] firstVector, double[] secondVector) {
        int size = firstVector.length;
        double[] result = new double[size];
        Arrays.fill(result, 0.0);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int k;
                int n = k = i - j < 0 ? i - j + size : i - j;
                if (this.permutation1[j] >= 0) {
                    if (this.permutation2[k] >= 0) {
                        int n2 = i;
                        result[n2] = result[n2] + firstVector[this.permutation1[j]] * secondVector[this.permutation2[k]];
                        continue;
                    }
                    int n3 = i;
                    result[n3] = result[n3] + firstVector[this.permutation1[j]] * -secondVector[-this.permutation2[k]];
                    continue;
                }
                if (this.permutation2[k] >= 0) {
                    int n4 = i;
                    result[n4] = result[n4] + -firstVector[-this.permutation1[j]] * secondVector[this.permutation2[k]];
                    continue;
                }
                int n5 = i;
                result[n5] = result[n5] + -firstVector[-this.permutation1[j]] * -secondVector[-this.permutation2[k]];
            }
        }
        return result;
    }

    public double[] shuffledConvolutionFFT(double[] firstVector, double[] secondVector) {
        return this.circularConvolutionFFT(VectorComposer.shuffle(firstVector, this.permutation1), VectorComposer.shuffle(secondVector, this.permutation2));
    }
}

