/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.exp.dtk;

import it.uniroma2.exp.AbstractExperiment;
import it.uniroma2.exp.tools.AvgVarCalculator;
import it.uniroma2.util.math.ArrayMath;
import it.uniroma2.util.math.MatrixUtils;
import it.uniroma2.util.vector.RandomVectorGenerator;
import it.uniroma2.util.vector.VectorComposer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class VectorTester
extends AbstractExperiment {
    public static final int[] NUMBER_OF_VECTORS = new int[]{20, 50, 100, 200, 500};
    public static final int[] NUMBER_OF_COMMON_VECTORS = new int[]{0, 1, 2, 5, 10};
    public static final int TRIALS = 100;

    public static void main(String[] args) {
        VectorTester vt = new VectorTester();
        try {
            vt.setOutputStream(new PrintStream(new File("vector_tester.dat")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(0);
        }
        vt.setVectorSizeArray(new int[]{4096});
        vt.runAll();
    }

    protected void runExperiment() throws Exception {
        RandomVectorGenerator rvg = new RandomVectorGenerator(this.vectorSize, this.randomOffset);
        this.out.print("\t");
        for (int commonVecs : NUMBER_OF_COMMON_VECTORS) {
            this.out.print(commonVecs + "\t\t");
        }
        for (int numVecs : NUMBER_OF_VECTORS) {
            rvg.setRandomSeed(this.vectorSize * numVecs);
            this.out.print("\n" + numVecs + "\t");
            for (int commonVecs : NUMBER_OF_COMMON_VECTORS) {
                AvgVarCalculator avg = new AvgVarCalculator();
                for (int k = 0; k < 100; ++k) {
                    int i;
                    double[] sum1 = MatrixUtils.uniformVector(rvg.getVectorSize(), 0.0);
                    double[] sum2 = MatrixUtils.uniformVector(rvg.getVectorSize(), 0.0);
                    for (i = 0; i < commonVecs; ++i) {
                        double[] vec = rvg.generateRandomVector();
                        sum1 = VectorComposer.sum(sum1, vec);
                        sum2 = VectorComposer.sum(sum2, vec);
                    }
                    for (i = 0; i < numVecs - commonVecs; ++i) {
                        sum1 = VectorComposer.sum(sum1, rvg.generateRandomVector());
                    }
                    for (i = 0; i < numVecs - commonVecs; ++i) {
                        sum2 = VectorComposer.sum(sum2, rvg.generateRandomVector());
                    }
                    avg.addSample(ArrayMath.dot(sum1, sum2));
                }
                this.out.print(avg.getFormattedResult() + "\t");
            }
        }
        this.out.println();
    }
}

