/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.svd.writer;

import it.uniroma2.svd.writer.BinaryMatrix;
import it.uniroma2.util.math.ArrayMath;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseBinaryMatrix<T>
implements BinaryMatrix<T> {
    private RandomAccessFile _matrixFile;
    private int n_row = -1;
    private int n_col = -1;
    private boolean sized = false;
    private int sizeType;
    private Class<T> tClass;
    private Method readMethod;
    private Method writeMethod;
    private int currentrow;

    public DenseBinaryMatrix(Class<T> c) {
        this.tClass = c;
        this.setType();
    }

    @Override
    public void openFile(String file, String mode) throws IOException {
        File f = new File(file);
        boolean exist = f.exists();
        this._matrixFile = new RandomAccessFile(file, mode);
        if (this.sized) {
            long len = 8L + (long)this.n_row * (long)this.n_col * (long)this.sizeType;
            this._matrixFile.setLength(len);
            this.writeSize();
        }
        if (exist) {
            this.readSize();
        }
    }

    public void openFile(String file, String mode, boolean sized) throws IOException {
        File f = new File(file);
        boolean exist = f.exists();
        this._matrixFile = new RandomAccessFile(file, mode);
        if (sized) {
            long len = 8L + (long)this.n_row * (long)this.n_col * (long)this.sizeType;
            this._matrixFile.setLength(len);
            this.writeSize();
        }
        if (exist) {
            this.readSize();
        }
    }

    @Override
    public void closeFile() throws IOException {
        this._matrixFile.close();
    }

    public void writeInt(Integer i) throws IOException {
        this._matrixFile.writeInt(i);
    }

    public void writeFloat(Float i) throws IOException {
        this._matrixFile.writeFloat(i.floatValue());
    }

    public void writeDouble(Double i) throws IOException {
        this._matrixFile.writeDouble(i);
    }

    public Integer readInt() throws IOException {
        return this._matrixFile.readInt();
    }

    public Float readFloat() throws IOException {
        return Float.valueOf(this._matrixFile.readFloat());
    }

    public Double readDouble() throws IOException {
        return this._matrixFile.readDouble();
    }

    public void setSize(int row, int col) {
        this.n_col = col;
        this.n_row = row;
        this.sized = true;
    }

    public void setCol(int col) {
        this.n_col = col;
    }

    public void setType() {
        try {
            if (this.tClass.equals(Integer.class)) {
                this.sizeType = 4;
                this.readMethod = this.getClass().getMethod("readInt", new Class[0]);
                this.writeMethod = this.getClass().getMethod("writeInt", Integer.class);
            } else if (this.tClass.equals(Float.class)) {
                this.readMethod = this.getClass().getMethod("readFloat", new Class[0]);
                this.writeMethod = this.getClass().getMethod("writeFloat", Float.class);
                this.sizeType = 4;
            } else if (this.tClass.equals(Double.class)) {
                this.readMethod = this.getClass().getMethod("readDouble", new Class[0]);
                this.writeMethod = this.getClass().getMethod("writeDouble", Double.class);
                this.sizeType = 8;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public void readSize() throws IOException {
        this._matrixFile.seek(0L);
        this.n_row = this._matrixFile.readInt();
        this.n_col = this._matrixFile.readInt();
    }

    public void writeSize() throws IOException {
        this._matrixFile.seek(0L);
        this._matrixFile.writeInt(this.n_row);
        this._matrixFile.writeInt(this.n_col);
        this._matrixFile.setLength(this.getPos(this.n_row, this.n_col) + (long)this.sizeType);
    }

    private long getPos(int row, int col) {
        return 8L + ((long)row * (long)this.n_col + (long)col) * (long)this.sizeType;
    }

    @Override
    public void setElement(int row, int col, T value) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (row >= this.n_row) {
            this.n_row = row + 1;
        }
        this._matrixFile.seek(this.getPos(row, col));
        this.writeMethod.invoke((Object)this, value);
    }

    @Override
    public void setFullRow(int row, T[] fs) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this._matrixFile.seek(this.getPos(row, 0));
        for (int i = 0; i < fs.length; ++i) {
            this.writeMethod.invoke((Object)this, fs[i]);
        }
    }

    public void setFullMatrix(T[][] ma) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.n_row = ma.length;
        this.n_col = ma[0].length;
        this.writeSize();
        this._matrixFile.seek(this.getPos(0, 0));
        for (int i = 0; i < ma.length; ++i) {
            for (int j = 0; j < ma[i].length; ++j) {
                this.writeMethod.invoke((Object)this, ma[i][j]);
            }
        }
    }

    public void setFullRowFloat(int row, Float[] fs) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this._matrixFile.seek(this.getPos(row, 0));
        byte[] buffer = new byte[fs.length * 4];
        ByteBuffer buf = ByteBuffer.wrap(buffer);
        for (int i = 0; i < fs.length; ++i) {
            buf.putFloat(fs[i].floatValue());
        }
        this._matrixFile.write(buffer);
    }

    public void setFullMatrixFloat(Float[][] ma) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.n_row = ma.length;
        this.n_col = ma[0].length;
        this.writeSize();
        this._matrixFile.seek(this.getPos(0, 0));
        for (int i = 0; i < ma.length; ++i) {
            byte[] buffer = new byte[this.n_col * 4];
            ByteBuffer buf = ByteBuffer.wrap(buffer);
            for (int j = 0; j < ma[i].length; ++j) {
                buf.putFloat(ma[i][j].floatValue());
            }
            this._matrixFile.write(buffer);
        }
    }

    public Float[][] getFullMatrixFloat() throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Float[][] tmp = new Float[this.n_row][this.n_col];
        this._matrixFile.seek(this.getPos(0, 0));
        for (int i = 0; i < this.n_row; ++i) {
            if (i % 1000 == 0) {
                System.out.print("" + i + ".");
            }
            byte[] buffer = new byte[this.n_col * 4];
            this._matrixFile.read(buffer);
            ByteBuffer buf = ByteBuffer.wrap(buffer);
            for (int j = 0; j < this.n_col; ++j) {
                tmp[i][j] = Float.valueOf(buf.getFloat());
            }
        }
        System.out.println("" + this.n_row + " read!");
        return tmp;
    }

    public Float[] getFullRowFloat(int row) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        Float[] tmp = new Float[this.n_col];
        this._matrixFile.seek(this.getPos(row, 0));
        byte[] buffer = new byte[this.n_col * 4];
        this._matrixFile.read(buffer);
        ByteBuffer buf = ByteBuffer.wrap(buffer);
        for (int i = 0; i < this.n_col; ++i) {
            tmp[i] = Float.valueOf(buf.getFloat());
        }
        return tmp;
    }

    public Float[] getNextFullRowFloat() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        Float[] tmp = new Float[this.n_col];
        byte[] buffer = new byte[this.n_col * 4];
        this._matrixFile.read(buffer);
        ByteBuffer buf = ByteBuffer.wrap(buffer);
        for (int i = 0; i < this.n_col; ++i) {
            tmp[i] = Float.valueOf(buf.getFloat());
        }
        ++this.currentrow;
        return tmp;
    }

    public T[][] getFullMatrix() throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[][] tmp = (Object[][])Array.newInstance(this.tClass, this.n_row, this.n_col);
        this._matrixFile.seek(this.getPos(0, 0));
        for (int i = 0; i < this.n_row; ++i) {
            for (int j = 0; j < this.n_col; ++j) {
                tmp[i][j] = this.readMethod.invoke((Object)this, null);
            }
        }
        return tmp;
    }

    public void setFullRow(int row, SortedMap<Integer, T> items) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this._matrixFile.seek(this.getPos(row, 0));
        for (int i : items.keySet()) {
            this.writeMethod.invoke((Object)this, items.get(i));
        }
    }

    public void setFullCol(int col, SortedMap<Integer, T> items) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (int i = 0; i < this.n_row; ++i) {
            this._matrixFile.seek(this.getPos(i, col));
            this.writeMethod.invoke((Object)this, items.get(i));
        }
    }

    @Override
    public void setFullCol(int col, T[] colelem) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (int i = 0; i < colelem.length; ++i) {
            this._matrixFile.seek(this.getPos(i, col));
            this.writeMethod.invoke((Object)this, colelem[i]);
        }
    }

    @Override
    public void setSparseRow(int row, Map<Integer, T> values) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Integer i : values.keySet()) {
            this._matrixFile.seek(this.getPos(row, i));
            this.writeMethod.invoke((Object)this, values.get(i));
        }
    }

    @Override
    public void setSparseCol(int col, Map<Integer, T> values) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Integer i : values.keySet()) {
            this._matrixFile.seek(this.getPos(i, col));
            this.writeMethod.invoke((Object)this, values.get(i));
        }
    }

    @Override
    public T getElement(int row, int col) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this._matrixFile.seek(this.getPos(row, col));
        return (T)this.readMethod.invoke((Object)this, null);
    }

    @Override
    public T[] getFullRow(int row) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        Object[] tmp = (Object[])Array.newInstance(this.tClass, this.n_col);
        this._matrixFile.seek(this.getPos(row, 0));
        for (int i = 0; i < this.n_col; ++i) {
            tmp[i] = this.readMethod.invoke((Object)this, null);
        }
        return tmp;
    }

    public void seekRowZero() throws IOException {
        this._matrixFile.seek(this.getPos(0, 0));
        this.currentrow = 0;
    }

    public T[] getNextFullRow() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        Object[] tmp = (Object[])Array.newInstance(this.tClass, this.n_col);
        ++this.currentrow;
        for (int i = 0; i < this.n_col; ++i) {
            tmp[i] = this.readMethod.invoke((Object)this, null);
        }
        return tmp;
    }

    public TreeMap<Integer, T> getFullRowTreeMap(int row) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        TreeMap<Integer, Object> res = new TreeMap<Integer, Object>();
        this._matrixFile.seek(this.getPos(row, 0));
        for (int i = 0; i < this.n_col; ++i) {
            res.put(i, this.readMethod.invoke((Object)this, null));
        }
        return res;
    }

    public TreeMap<Integer, T> getNextFullRowTreeMap() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        TreeMap<Integer, Object> res = new TreeMap<Integer, Object>();
        ++this.currentrow;
        for (int i = 0; i < this.n_col; ++i) {
            res.put(i, this.readMethod.invoke((Object)this, null));
        }
        return res;
    }

    @Override
    public TreeMap<Integer, T> getSparseRow(int row) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        TreeMap<Integer, Object> res = new TreeMap<Integer, Object>();
        Float zero = new Float(0.0f);
        this._matrixFile.seek(this.getPos(row, 0));
        for (int i = 0; i < this.n_col; ++i) {
            Object val = this.readMethod.invoke((Object)this, null);
            if (val.equals(zero)) continue;
            res.put(i, val);
        }
        return res;
    }

    public TreeMap<Integer, T> getFullColTreeMap(int col) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        TreeMap<Integer, Object> res = new TreeMap<Integer, Object>();
        for (int i = 0; i < this.n_row; ++i) {
            this._matrixFile.seek(this.getPos(i, col));
            res.put(i, this.readMethod.invoke((Object)this, null));
        }
        return res;
    }

    @Override
    public T[] getFullCol(int col) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] tmp = (Object[])Array.newInstance(this.tClass, this.n_row);
        for (int i = 0; i < this.n_row; ++i) {
            this._matrixFile.seek(this.getPos(i, col));
            tmp[i] = this.readMethod.invoke((Object)this, null);
        }
        return tmp;
    }

    @Override
    public TreeMap<Integer, T> getSparseCol(int col) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        TreeMap<Integer, Object> res = new TreeMap<Integer, Object>();
        Float zero = new Float(0.0f);
        for (int i = 0; i < this.n_row; ++i) {
            this._matrixFile.seek(this.getPos(i, col));
            Object val = this.readMethod.invoke((Object)this, null);
            if (val.equals(zero)) continue;
            res.put(i, val);
        }
        return res;
    }

    @Override
    public int getCols() {
        return this.n_col;
    }

    @Override
    public int getRows() {
        return this.n_row;
    }

    public void setRows(int rows) {
        this.n_row = rows;
    }

    public void execRowOperation(Operator op, int row, T val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException, SecurityException, NoSuchMethodException {
        T[] rowelem = this.getFullRow(row);
        Method operation = null;
        operation = this.getClass().getMethod(op.name().toLowerCase(), this.tClass, this.tClass);
        for (int i = 0; i < rowelem.length; ++i) {
            rowelem[i] = operation.invoke((Object)this, rowelem[i], val);
        }
        this.setFullRow(row, rowelem);
    }

    public void convertToSparseByCol(String outFile) throws IllegalArgumentException, IOException, IllegalAccessException, InvocationTargetException {
        RandomAccessFile sparse = new RandomAccessFile(outFile, "rw");
        sparse.writeInt(this.n_row);
        sparse.writeInt(this.n_col);
        sparse.seek(12L);
        int nonzero = 0;
        for (int i = 0; i < this.n_col; ++i) {
            TreeMap<Integer, T> col = this.getSparseCol(i);
            sparse.writeInt(col.size());
            nonzero += col.size();
            for (int j : col.keySet()) {
                Float e = (Float)col.get(j);
                sparse.writeInt(j);
                sparse.writeFloat(e.floatValue());
            }
            System.out.print(".");
        }
        sparse.seek(8L);
        sparse.writeInt(nonzero);
        sparse.close();
    }

    public void convertToSparseByRow(String outFile) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RandomAccessFile sparse = new RandomAccessFile(outFile, "rw");
        sparse.writeInt(this.n_row);
        sparse.writeInt(this.n_col);
        sparse.seek(12L);
        int nonzero = 0;
        for (int i = 0; i < this.n_row; ++i) {
            TreeMap<Integer, T> row = this.getSparseRow(i);
            sparse.writeInt(row.size());
            nonzero += row.size();
            for (int j : row.keySet()) {
                Float e = (Float)row.get(j);
                sparse.writeInt(j);
                sparse.writeFloat(e.floatValue());
            }
        }
        sparse.seek(8L);
        sparse.writeInt(nonzero);
        sparse.close();
    }

    public Double sum(Double a, Double b) {
        Double res = a + b;
        return res;
    }

    public Float sum(Float a, Float b) {
        Float res = Float.valueOf(a.floatValue() + b.floatValue());
        return res;
    }

    public Integer sum(Integer a, Integer b) {
        Integer res = a + b;
        return res;
    }

    public Double mult(Double a, Double b) {
        return a * b;
    }

    public Float mult(Float a, Float b) {
        return Float.valueOf(a.floatValue() * b.floatValue());
    }

    public Integer mult(Integer a, Integer b) {
        return a * b;
    }

    public Double div(Double a, Double b) {
        return a / b;
    }

    public Float div(Float a, Float b) {
        return Float.valueOf(a.floatValue() / b.floatValue());
    }

    public Integer div(Integer a, Integer b) {
        return a / b;
    }

    public void printAll() throws IOException, IllegalAccessException, InvocationTargetException {
        this._matrixFile.seek(0L);
        int rows = this._matrixFile.readInt();
        int cols = this._matrixFile.readInt();
        System.out.println(rows + " " + cols);
        for (int i = 0; i < rows; ++i) {
            System.out.println();
            for (int j = 0; j < cols; ++j) {
                this._matrixFile.seek(this.getPos(i, j));
                System.out.print(this.readMethod.invoke((Object)this, null) + "\t");
            }
        }
        System.out.println("\n");
    }

    public static void main(String[] args) {
        DenseBinaryMatrix<Float> mat = new DenseBinaryMatrix<Float>(Float.class);
        if (args.length != 1) {
            System.out.println("Usage: " + DenseBinaryMatrix.class + " <matrix>");
        }
        try {
            System.out.println("openfile");
            mat.openFile(args[0], "r");
            mat.readSize();
            System.out.println(mat.getRows() + " " + mat.getCols());
            FileWriter output = new FileWriter(args[0] + ".dsm");
            for (int i = 0; i < mat.getRows(); ++i) {
                output.write(ArrayMath.arrayToString(mat.getFullRow(i)) + "\n");
                System.out.print('.');
            }
            output.close();
            System.out.println("Closing file");
            mat.closeFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        SUM,
        DIV,
        MULT;

    }
}

