/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.svd.writer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadFileWords {
    private Vector<String> frame;
    private Vector<String> words;
    private Vector<String> pos;
    private Vector<Integer> TypeFrame = new Vector();
    private Vector<String> LU1 = new Vector();
    private Vector<String> LU2 = new Vector();

    public ReadFileWords() throws Exception {
    }

    public ReadFileWords(String path) throws Exception {
        this.words = new Vector();
        this.frame = new Vector();
        this.pos = new Vector();
        try {
            File _file = new File(path);
            if (!_file.isFile() || !_file.canRead()) {
                return;
            }
            FileReader fr = new FileReader(_file);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                StringTokenizer st = new StringTokenizer(line, "\t");
                this.frame.addElement(st.nextToken().trim());
                this.words.addElement(st.nextToken().trim());
                this.pos.addElement(st.nextToken().trim());
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public void readFileLUs(String path) throws Exception {
        try {
            File _file = new File(path);
            if (!_file.isFile() || !_file.canRead()) {
                return;
            }
            FileReader fr = new FileReader(_file);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                StringTokenizer st = new StringTokenizer(line, "\t");
                this.TypeFrame.addElement(Integer.parseInt(st.nextToken().trim()));
                this.LU1.addElement(st.nextToken().trim());
                this.LU2.addElement(st.nextToken().trim());
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public Vector<String> getWords() {
        return this.words;
    }

    public Vector<String> getFrame() {
        return this.frame;
    }

    public Vector<String> getPOS() {
        return this.pos;
    }

    public Vector<Integer> getTypeFrame() {
        return this.TypeFrame;
    }

    public void setTypeFrame(Vector<Integer> typeFrame) {
        this.TypeFrame = typeFrame;
    }

    public Vector<String> getLU1() {
        return this.LU1;
    }

    public void setLU1(Vector<String> lu1) {
        this.LU1 = lu1;
    }

    public Vector<String> getLU2() {
        return this.LU2;
    }

    public void setLU2(Vector<String> lu2) {
        this.LU2 = lu2;
    }
}

