/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.util.math.statistical;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROCanalyzer {
    public float A = 0.0f;
    boolean verbose = false;

    public static void main(String[] argv) throws Exception {
        if (argv.length != 3) {
            System.out.println("Arguments:\n\t1) trueSet file\n\t2) controlSet\n\t3) outFile\n");
            System.exit(-1);
        } else {
            ROCanalyzer ra = new ROCanalyzer();
            ra.Run(argv[0], argv[1], argv[2]);
        }
    }

    public void Run(String trueFile, String controlFile, String outF) throws Exception {
        BufferedReader brT = new BufferedReader(new FileReader(trueFile));
        BufferedReader brC = new BufferedReader(new FileReader(controlFile));
        BufferedWriter outFile = new BufferedWriter(new FileWriter(outF));
        Vector<ROCdata> vCouple = new Vector<ROCdata>();
        String inLine = "";
        int N = 0;
        int P = 0;
        int i = 0;
        while ((inLine = brT.readLine()) != null) {
            vCouple.add(new ROCdata(inLine, i, true));
            ++P;
            ++i;
        }
        while ((inLine = brC.readLine()) != null) {
            vCouple.add(new ROCdata(inLine, i, false));
            ++N;
            ++i;
        }
        vCouple = this.sort(vCouple);
        if (this.verbose) {
            System.out.println("POINTS IN ROC INPUT VECTOR: " + vCouple.size());
            for (int m = 0; m < vCouple.size(); ++m) {
                System.out.println(vCouple.elementAt((int)m).f_);
            }
        }
        Vector<point> p = this.ROC(vCouple, P, N);
        outFile.write("------------- ROC CURVE POINTS -------------\n\n");
        outFile.write("FPrate\tTPrate\tprec\trec\tf-meas\taccur\n");
        if (this.verbose) {
            System.out.println("POINTS IN ROC CURVE: " + p.size());
            System.out.println("------------- ROC CURVE POINTS -------------\n");
            System.out.println("FPrate\tTPrate\tprec\trec\tf-meas\taccur\n");
        }
        for (int j = 0; j < p.size(); ++j) {
            if (this.verbose) {
                System.out.println(p.elementAt(j).toStringa());
            }
            outFile.write(p.elementAt(j).toStringa() + "\n");
        }
        if (this.verbose) {
            System.out.println("\n\n------------- AROC AREAS : \n" + this.A);
        } else {
            System.out.print("" + this.A);
        }
        outFile.write("\n\n------------- AROC AREAS : " + this.A + "\n");
        outFile.close();
        brT.close();
        brC.close();
    }

    public double aroc(Vector<String> positives, Vector<String> control_elements) {
        Vector<ROCdata> vCouple = new Vector<ROCdata>();
        int N = 0;
        int P = 0;
        int i = 0;
        for (String positive : positives) {
            vCouple.add(new ROCdata(positive, i, true));
            ++P;
            ++i;
        }
        for (String control_element : control_elements) {
            vCouple.add(new ROCdata(control_element, i, false));
            ++N;
            ++i;
        }
        vCouple = this.sort(vCouple);
        if (this.verbose) {
            System.out.println("POINTS IN ROC INPUT VECTOR: " + vCouple.size());
            for (int m = 0; m < vCouple.size(); ++m) {
                System.out.println(vCouple.elementAt((int)m).f_);
            }
        }
        Vector<point> p = this.ROC(vCouple, P, N);
        if (this.verbose) {
            System.out.println("POINTS IN ROC CURVE: " + p.size());
            System.out.println("------------- ROC CURVE POINTS -------------\n");
            System.out.println("FPrate\tTPrate\tprec\trec\tf-meas\taccur\n");
        }
        for (int j = 0; j < p.size(); ++j) {
            if (!this.verbose) continue;
            System.out.println(p.elementAt(j).toStringa());
        }
        if (this.verbose) {
            System.out.println("\n\n------------- AROC AREAS : \n" + this.A);
        }
        return this.A;
    }

    public Vector<ROCdata> sort(Vector<ROCdata> v) {
        class ROCcomparator
        implements Comparator {
            ROCcomparator() {
            }

            public int compare(Object o1, Object o2) {
                int ret = -1;
                ROCdata r1 = (ROCdata)o1;
                ROCdata r2 = (ROCdata)o2;
                if (r2.f_ - r1.f_ >= 0.0f) {
                    ret = 1;
                } else if (r2.f_ - r1.f_ < 0.0f) {
                    ret = -1;
                }
                return ret;
            }
        }
        Collections.sort(v, new ROCcomparator());
        return v;
    }

    public Vector<point> ROC(Vector<ROCdata> vSample, int P, int N) {
        int FP = 0;
        int TP = 0;
        int TN = 0;
        int FN = 0;
        int FPprev = 0;
        int TPprev = 0;
        this.A = 0.0f;
        Vector<point> vPoint = new Vector<point>();
        float f = -99999.0f;
        for (int i = 0; i < vSample.size(); ++i) {
            ROCdata sample = vSample.elementAt(i);
            if (sample.f_ != f) {
                TN = N - FP;
                FN = P - TP;
                this.A += this.trapArea(FP, FPprev, TP, TPprev);
                vPoint.add(new point(TP, FP, TN, FN, P, N));
                f = sample.f_;
                FPprev = FP;
                TPprev = TP;
            }
            if (sample.positive_) {
                ++TP;
                continue;
            }
            ++FP;
        }
        TN = N - FP;
        FN = P - TP;
        this.A += this.trapArea(N, FPprev, P, TPprev);
        vPoint.add(new point(TP, FP, TN, FN, P, N));
        this.A /= (float)(N * P);
        if (this.verbose) {
            System.out.println("N:" + N);
        }
        if (this.verbose) {
            System.out.println("P:" + P);
        }
        return vPoint;
    }

    public float trapArea(float X1, float X2, float Y1, float Y2) {
        float base = Math.abs(X1 - X2);
        float high = (Y1 + Y2) / 2.0f;
        if (this.verbose) {
            System.out.println("X1=" + X1 + "\tX2=" + X2 + "\tY1=" + Y1 + "\tY2=" + Y2);
        }
        if (this.verbose) {
            System.out.println("base=" + base + "\thigh=" + high + "\tarea=" + base * high);
        }
        return base * high;
    }

    private class ROCdata {
        protected int id_;
        protected boolean positive_;
        protected float f_;

        protected ROCdata(String in, int id, boolean positive) {
            try {
                StringTokenizer st = new StringTokenizer(in, "\t");
                this.id_ = id;
                this.f_ = new Float(st.nextToken()).floatValue();
                this.positive_ = positive;
            }
            catch (Exception e) {
                System.out.println("Incorrect file format in line: <" + in + ">\nFormat must be <verb-couple>\t<function value>");
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    private class point {
        protected float FPrate_;
        protected float TPrate_;
        protected float prec_;
        protected float rec_;
        protected float fMeasure_;
        protected float acc_;

        protected point(int TP_, int FP_, int TN_, int FN_, int P_, int N_) {
            float TP = new Float(TP_).floatValue();
            float FP = new Float(FP_).floatValue();
            float TN = new Float(TN_).floatValue();
            float FN = new Float(FN_).floatValue();
            float P = new Float(P_).floatValue();
            float N = new Float(N_).floatValue();
            this.FPrate_ = FP / N;
            this.TPrate_ = TP / P;
            this.prec_ = TP / (TP + FP);
            this.rec_ = this.TPrate_;
            this.fMeasure_ = 2.0f * this.rec_ * this.prec_ / (this.rec_ + this.prec_);
            this.acc_ = (TP + TN) / (P + N);
        }

        protected String toStringa() {
            return this.FPrate_ + "\t" + this.TPrate_ + "\t" + this.prec_ + "\t" + this.rec_ + "\t" + this.fMeasure_ + "\t" + this.acc_;
        }
    }
}

