/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.util.vector;

import it.uniroma2.util.math.ArrayMath;
import it.uniroma2.util.vector.VectorProvider;
import java.util.Random;

public class RandomVectorGenerator
implements VectorProvider {
    private Random random;
    private int offset;
    private int vectorSize;

    public RandomVectorGenerator(int vectorSize) {
        this(vectorSize, 0);
    }

    public RandomVectorGenerator(int vectorSize, int offset) {
        this.random = new Random(offset);
        this.offset = offset;
        this.vectorSize = vectorSize;
    }

    public void setVectorSize(int vectorSize) {
        this.vectorSize = vectorSize;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setRandomSeed(int seed) {
        this.random.setSeed(seed + this.offset);
    }

    public double[] generateRandomVector() {
        double[] randomVector = new double[this.vectorSize];
        for (int i = 0; i < this.vectorSize; ++i) {
            randomVector[i] = this.random.nextGaussian();
        }
        try {
            randomVector = ArrayMath.versor(randomVector);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return randomVector;
    }

    public double[] generateRandomVector(int seed) {
        this.setRandomSeed(seed);
        return this.generateRandomVector();
    }

    public double[] getVector(String term) {
        return this.generateRandomVector(term.hashCode());
    }

    public int getVectorSize() {
        return this.vectorSize;
    }
}

