/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.util.vector;

import java.util.Arrays;

public class VectorComposer {
    public static double[] sum(double[] firstVector, double[] secondVector) {
        if (firstVector == null) {
            return secondVector;
        }
        if (secondVector == null) {
            return firstVector;
        }
        int size = firstVector.length;
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = firstVector[i] + secondVector[i];
        }
        return result;
    }

    public static double[] reverse(double[] vector) {
        if (vector == null) {
            return null;
        }
        int size = vector.length;
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = vector[vector.length - 1 - i];
        }
        return result;
    }

    public static double[] shift(double[] vector) {
        if (vector == null) {
            return null;
        }
        int size = vector.length;
        double[] result = new double[size];
        result[0] = vector[size - 1];
        for (int i = 1; i < size; ++i) {
            result[i] = vector[i - 1];
        }
        return result;
    }

    public static double[] shuffle(double[] vector, int[] permutation) {
        if (vector == null || vector.length != permutation.length) {
            return null;
        }
        double[] shuffled = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            shuffled[i] = permutation[i] >= 0 ? vector[permutation[i]] : -vector[-permutation[i]];
        }
        return shuffled;
    }

    public double[] matrixTransform(double[] vector, double[][] matrix) {
        if (vector == null || vector.length != matrix.length || vector.length != matrix[0].length) {
            return null;
        }
        int size = vector.length;
        double[] translated = new double[size];
        Arrays.fill(translated, 0.0);
        double[] secondTranslated = new double[size];
        Arrays.fill(secondTranslated, 0.0);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int n = i;
                translated[n] = translated[n] + vector[j] * matrix[i][j];
            }
        }
        return translated;
    }
}

