/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.conja;

import com.davidsoergel.conja.TaskGroup;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComparableFutureTask<T>
extends FutureTask<T>
implements Comparable<ComparableFutureTask> {
    int[] priority;
    TaskGroup tg;
    private static final Logger logger = Logger.getLogger(ComparableFutureTask.class);

    public ComparableFutureTask(Callable<T> tCallable, int[] priority, TaskGroup tg) {
        super(tCallable);
        this.priority = priority;
        this.tg = tg;
    }

    public ComparableFutureTask(Runnable tCallable, int[] priority, TaskGroup tg) {
        super(tCallable, null);
        this.priority = priority;
        this.tg = tg;
    }

    @Override
    public int compareTo(ComparableFutureTask o) {
        int level = this.priority.length;
        int olevel = o.priority.length;
        if (level > olevel) {
            return -1;
        }
        if (olevel < level) {
            return 1;
        }
        for (int i = 0; i < level; ++i) {
            if (this.priority[i] < o.priority[i]) {
                return -1;
            }
            if (this.priority[i] <= o.priority[i]) continue;
            return 1;
        }
        return 0;
    }

    public static String asString(int[] x, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < x.length; ++i) {
            int i1 = x[i];
            sb.append(i1);
            if (i == x.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    @Override
    public void run() {
        int[] lastPriority;
        block5: {
            if (logger.isDebugEnabled()) {
                logger.debug("Running " + ComparableFutureTask.asString(this.priority, ","));
            }
            lastPriority = TaskGroup._currentTaskPriority.get();
            TaskGroup._currentTaskPriority.set(this.priority);
            try {
                super.run();
            }
            catch (Throwable e) {
                Throwable c = e.getCause();
                while (c != null && c != e) {
                    e = c;
                    logger.error("Error", e);
                    c = e.getCause();
                }
                if (e instanceof OutOfMemoryError) {
                    this.tg.shutdownNow();
                }
                if (!(e instanceof RuntimeException)) break block5;
                throw (RuntimeException)e;
            }
        }
        TaskGroup._currentTaskPriority.set(lastPriority);
        this.tg.reportDone(this);
    }
}

