/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.conja;

import com.davidsoergel.conja.ComparableFutureTask;
import com.davidsoergel.conja.RuntimeExecutionException;
import com.davidsoergel.conja.TaskGroup;
import com.davidsoergel.conja.ThreadPoolPerformanceStats;
import com.davidsoergel.conja.TrackedThreadFactory;
import com.davidsoergel.conja.TreeExecutorService;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepthFirstThreadPoolExecutor
implements TreeExecutorService {
    private static final Logger logger = Logger.getLogger(DepthFirstThreadPoolExecutor.class);
    private static DepthFirstThreadPoolExecutor _instance = null;
    private static int _instance_cpus = 0;
    private ThreadPoolExecutor underlyingExecutor;
    private int queueSizePerTaskGroup;
    private final TrackedThreadFactory threadFactory;

    public static DepthFirstThreadPoolExecutor getInstance() {
        if (_instance == null) {
            _instance = new DepthFirstThreadPoolExecutor(_instance_cpus);
        }
        return _instance;
    }

    public static void set_instance_cpus(int _instance_cpus) {
        DepthFirstThreadPoolExecutor._instance_cpus = _instance_cpus;
        if (_instance != null) {
            _instance.shutdown();
            _instance = null;
        }
    }

    public int getPoolSize() {
        return this.underlyingExecutor.getPoolSize();
    }

    public DepthFirstThreadPoolExecutor() {
        this(0);
    }

    public DepthFirstThreadPoolExecutor(int threads) {
        this(threads, 0);
    }

    public DepthFirstThreadPoolExecutor(int threads, int queueSizePerTaskGroup) {
        if (threads == 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        if (queueSizePerTaskGroup == 0) {
            queueSizePerTaskGroup = threads * 2;
        }
        this.queueSizePerTaskGroup = queueSizePerTaskGroup;
        this.threadFactory = new TrackedThreadFactory();
        this.underlyingExecutor = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), this.threadFactory);
        this.underlyingExecutor.prestartAllCoreThreads();
    }

    @Override
    public void submitAndWaitForAll(Iterable<Runnable> tasks) {
        this.submitAndWaitForAll(tasks.iterator());
    }

    @Override
    public ThreadPoolPerformanceStats shutdown() {
        ThreadPoolPerformanceStats stats = this.threadFactory.getStats();
        logger.warn("Shutting down depth-first executor: " + stats);
        this.underlyingExecutor.shutdown();
        return stats;
    }

    public void shutdownNow() {
        this.underlyingExecutor.shutdownNow();
        if (this == _instance) {
            _instance = null;
        }
    }

    @Override
    public void submitAndWaitForAll(Iterator<Runnable> tasks) {
        boolean isWorkerThread;
        TaskGroup taskGroup = new TaskGroup(tasks, this.queueSizePerTaskGroup);
        boolean bl = isWorkerThread = Thread.currentThread().getThreadGroup() == this.threadFactory.group;
        if (isWorkerThread) {
            this.submitAndWaitForAllFromWorkerThread(taskGroup);
        } else {
            this.submitAndWaitForAllFromNonWorkerThread(taskGroup);
        }
    }

    private void submitAndWaitForAllFromWorkerThread(TaskGroup taskGroup) {
        while (taskGroup.hasNext()) {
            ComparableFutureTask ftask = taskGroup.nextIfPermitAvailable();
            while (taskGroup.hasNext() && ftask == null) {
                this.runTaskFromQueueOrSleep();
                ftask = taskGroup.nextIfPermitAvailable();
            }
            if (ftask == null) continue;
            boolean done = false;
            int rejectionCount = 0;
            while (!done) {
                try {
                    this.underlyingExecutor.execute(ftask);
                    done = true;
                }
                catch (RejectedExecutionException e) {
                    if (rejectionCount >= 10) {
                        throw new RuntimeExecutionException(e, "Task vas rejected 10 times in a row!");
                    }
                    ++rejectionCount;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e1) {
                        logger.error("Error", e1);
                    }
                }
            }
        }
        while (!taskGroup.isDone()) {
            this.runTaskFromQueueOrSleep();
        }
        try {
            taskGroup.getAllExceptions();
        }
        catch (ExecutionException e) {
            logger.error("Error", e);
            throw new RuntimeExecutionException(e);
        }
        catch (InterruptedException e) {
            logger.error("Error", e);
            throw new RuntimeExecutionException(e);
        }
    }

    private void submitAndWaitForAllFromNonWorkerThread(TaskGroup taskGroup) {
        while (taskGroup.hasNext()) {
            ComparableFutureTask ftask = taskGroup.next();
            if (ftask == null) continue;
            boolean done = false;
            boolean rejectionCount = false;
            while (!done) {
                try {
                    this.underlyingExecutor.execute(ftask);
                    done = true;
                }
                catch (RejectedExecutionException e) {
                    if (this.underlyingExecutor.isShutdown()) {
                        return;
                    }
                    throw new RuntimeExecutionException("Impossible: Executor rejects jobs even though it has not been shut down!?");
                }
            }
        }
        try {
            taskGroup.blockUntilDone();
            taskGroup.getAllExceptions();
        }
        catch (ExecutionException e) {
            logger.error("Error", e);
            throw new Error(e);
        }
        catch (InterruptedException e) {
            logger.error("Error", e);
            throw new Error(e);
        }
    }

    private void runTaskFromQueueOrSleep() {
        ComparableFutureTask task = (ComparableFutureTask)this.underlyingExecutor.getQueue().poll();
        if (task == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            task.run();
        }
    }
}

