/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.conja;

import com.davidsoergel.conja.ComparableFutureTask;
import com.davidsoergel.conja.MappingIterator;
import com.davidsoergel.conja.ThreadingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskGroup
extends MappingIterator<Runnable, ComparableFutureTask> {
    private final Set<ComparableFutureTask> futuresEnqueued = new HashSet<ComparableFutureTask>();
    private final Set<ComparableFutureTask> futuresDoneAwaitingResultCollection = new HashSet<ComparableFutureTask>();
    public static final ThreadLocal<int[]> _currentTaskPriority = new ThreadLocal();
    private int[] currentTaskPriority = _currentTaskPriority.get();
    private int subPriority = 0;
    private final Semaphore outstandingTasks;
    boolean aborted = false;

    protected TaskGroup(Iterator<Runnable> taskIterator, int queueSize) {
        super(taskIterator);
        this.outstandingTasks = new Semaphore(queueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isDone() {
        Set<ComparableFutureTask> set = this.futuresEnqueued;
        synchronized (set) {
            return this.futuresEnqueued.isEmpty() && !super.hasNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockUntilDone() throws ExecutionException, InterruptedException {
        assert (!super.hasNext());
        while (!this.futuresEnqueued.isEmpty()) {
            FutureTask future;
            Set<ComparableFutureTask> set = this.futuresEnqueued;
            synchronized (set) {
                Iterator<ComparableFutureTask> it = this.futuresEnqueued.iterator();
                future = it.hasNext() ? (FutureTask)it.next() : null;
            }
            if (future == null) continue;
            future.get();
            if (this.futuresEnqueued.isEmpty()) continue;
            Thread.sleep(10L);
        }
    }

    public synchronized void getAllExceptions() throws ExecutionException, InterruptedException {
        assert (this.isDone());
        Iterator<ComparableFutureTask> futuresDoneIterator = this.futuresDoneAwaitingResultCollection.iterator();
        while (futuresDoneIterator.hasNext()) {
            FutureTask future = futuresDoneIterator.next();
            future.get();
            futuresDoneIterator.remove();
        }
    }

    private static int[] arrayAppend(int[] currentTaskPriority, int subPriority) {
        int[] result;
        if (currentTaskPriority == null) {
            result = new int[]{subPriority};
        } else {
            result = Arrays.copyOf(currentTaskPriority, currentTaskPriority.length + 1);
            result[currentTaskPriority.length] = subPriority;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComparableFutureTask function(Runnable task) {
        Set<ComparableFutureTask> set = this.futuresEnqueued;
        synchronized (set) {
            int[] s = TaskGroup.arrayAppend(this.currentTaskPriority, this.subPriority);
            ComparableFutureTask ftask = new ComparableFutureTask(task, s, this);
            this.futuresEnqueued.add(ftask);
            ++this.subPriority;
            return ftask;
        }
    }

    @Override
    public ComparableFutureTask next() {
        if (!this.hasNext()) {
            return null;
        }
        this.outstandingTasks.acquireUninterruptibly();
        return (ComparableFutureTask)super.next();
    }

    public ComparableFutureTask nextIfPermitAvailable() {
        if (this.hasPermits()) {
            return this.next();
        }
        return null;
    }

    public boolean hasPermits() {
        return this.outstandingTasks.availablePermits() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportDone(ComparableFutureTask task) {
        Set<ComparableFutureTask> set = this.futuresEnqueued;
        synchronized (set) {
            if (!this.futuresEnqueued.remove(task)) {
                throw new ThreadingException("Can't report a task complete on the wrong TaskGroup");
            }
            this.futuresDoneAwaitingResultCollection.add(task);
            this.outstandingTasks.release();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.aborted && super.hasNext();
    }

    public void shutdownNow() {
        this.aborted = true;
        this.outstandingTasks.drainPermits();
    }
}

