/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.conja;

import com.davidsoergel.conja.ThreadPoolPerformanceStats;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class TrackedThreadFactory
implements ThreadFactory {
    static final AtomicInteger poolNumber = new AtomicInteger(1);
    final ThreadGroup group;
    final AtomicInteger threadNumber = new AtomicInteger(1);
    final String namePrefix;
    List<Long> createdThreadIds = new ArrayList<Long>();

    TrackedThreadFactory() {
        SecurityManager s = System.getSecurityManager();
        ThreadGroup parentGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        String poolName = "pool-" + poolNumber.getAndIncrement();
        this.group = new ThreadGroup(parentGroup, poolName);
        this.namePrefix = poolName + "-thread-";
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        bean.setThreadContentionMonitoringEnabled(true);
        bean.setThreadCpuTimeEnabled(true);
    }

    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        this.createdThreadIds.add(t.getId());
        return t;
    }

    public ThreadPoolPerformanceStats getStats() {
        return new ThreadPoolPerformanceStats(this.createdThreadIds);
    }
}

