/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils;

import com.davidsoergel.dsutils.CustomClassloaderObjectInputStream;
import com.davidsoergel.dsutils.EnvironmentUtils;
import com.google.common.collect.MapMaker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager {
    private static final Logger logger = Logger.getLogger(CacheManager.class);
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static final int MAX_KEY_LENGTH = 100;
    static ConcurrentMap<String, AccumulatingMap> accumulatingMaps;

    public static void setClassLoader(ClassLoader classLoader) {
        CacheManager.classLoader = classLoader;
    }

    public static void syncAccumulatingMaps() {
        for (AccumulatingMap accumulatingMap : accumulatingMaps.values()) {
            accumulatingMap.mergeToDisk();
        }
    }

    private static String hashAndVerify(Object source, String idString) {
        String idHash = String.valueOf(idString.hashCode());
        String cachedString = (String)CacheManager.get(source, idHash + ".idString");
        if (cachedString == null) {
            CacheManager.put(source, idHash + ".idString", (Serializable)((Object)idString));
        } else if (!cachedString.equals(idString)) {
            throw new Error("Hashcode collision, this is highly unlikely");
        }
        return idHash;
    }

    public static Object get(Object source, String key) {
        if (key.length() > 100) {
            key = CacheManager.hashAndVerify(source, key);
        }
        String filename = CacheManager.buildFilename(source, key);
        return CacheManager.getFromFile(filename);
    }

    public static Object get(String classNamePlusKey) {
        String filename = CacheManager.buildFilename(classNamePlusKey);
        return CacheManager.getFromFile(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFromFile(String filename) {
        FileInputStream fin = null;
        ObjectInputStream ois = null;
        try {
            fin = new FileInputStream(filename);
            ois = new CustomClassloaderObjectInputStream(fin, classLoader);
            Object object = ois.readObject();
            return object;
        }
        catch (FileNotFoundException e) {
            logger.debug("Cache not found: " + filename + ", " + e.getMessage());
        }
        catch (IOException e) {
            logger.warn("Error reading cache: " + filename + ", " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            logger.warn("Error reading cache: " + filename + ", " + e.getMessage());
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                logger.error("Error", e);
            }
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e) {
                logger.error("Error", e);
            }
        }
        return null;
    }

    public static void put(String classNamePlusKey, Serializable o) {
        String filename = CacheManager.buildFilename(classNamePlusKey);
        CacheManager.putToFile(filename, o);
    }

    public static void put(Object source, String key, Serializable o) {
        if (key.length() > 100) {
            key = CacheManager.hashAndVerify(source, key);
        }
        String filename = CacheManager.buildFilename(source, key);
        CacheManager.putToFile(filename, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void putToFile(String filename, Serializable o) {
        block44: {
            File cacheFile = new File(filename);
            cacheFile.getParentFile().mkdirs();
            FileOutputStream fout = null;
            ObjectOutputStream oos = null;
            FileChannel channel = null;
            FileLock lock = null;
            fout = new FileOutputStream(cacheFile);
            channel = fout.getChannel();
            lock = channel.lock();
            oos = new ObjectOutputStream(fout);
            oos.writeObject(o);
            Object var9_7 = null;
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException e2) {
                logger.error("Error", e2);
            }
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException e2) {
                logger.error("Error", e2);
            }
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e2) {
                logger.error("Error", e2);
            }
            try {
                if (fout != null) {
                    fout.close();
                }
                break block44;
            }
            catch (IOException e2) {
                logger.error("Error", e2);
            }
            break block44;
            {
                catch (FileNotFoundException e) {
                    logger.warn("Can't write cache, file not found: " + filename, e);
                    Object var9_8 = null;
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    try {
                        if (channel != null) {
                            channel.close();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    try {
                        if (fout != null) {
                            fout.close();
                        }
                        break block44;
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    break block44;
                }
                catch (IOException e) {
                    logger.warn("Can't write cache: " + filename, e);
                    Object var9_9 = null;
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    try {
                        if (channel != null) {
                            channel.close();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    try {
                        if (fout != null) {
                            fout.close();
                        }
                        break block44;
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (IOException e2) {
                    logger.error("Error", e2);
                }
                try {
                    if (channel != null) {
                        channel.close();
                    }
                }
                catch (IOException e2) {
                    logger.error("Error", e2);
                }
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e2) {
                    logger.error("Error", e2);
                }
                try {
                    if (fout != null) {
                        fout.close();
                    }
                }
                catch (IOException e2) {
                    logger.error("Error", e2);
                }
                throw throwable;
            }
        }
    }

    public static Map getAccumulatingMapAssumeSerializable(Object source, String key) {
        return CacheManager.getAccumulatingMap(source, key);
    }

    public static <K extends Serializable, V extends Serializable> Map<K, V> getAccumulatingMap(Object source, String key) {
        String filename;
        AccumulatingMap result;
        if (key.length() > 100) {
            key = CacheManager.hashAndVerify(source, key);
        }
        if ((result = (AccumulatingMap)accumulatingMaps.get(filename = CacheManager.buildFilename(source, key))) == null) {
            result = new AccumulatingMap(filename);
            accumulatingMaps.put(filename, result);
        }
        return result;
    }

    private static String buildFilename(Object source, String key) {
        String className = source.getClass().getCanonicalName();
        int i = className.indexOf(36);
        if (i >= 0) {
            className = className.substring(0, i);
        }
        return EnvironmentUtils.getCacheRoot() + className + File.separator + key;
    }

    private static String buildFilename(String classNamePlusKey) {
        return EnvironmentUtils.getCacheRoot() + classNamePlusKey;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                logger.debug("Running cleanup thread");
                try {
                    CacheManager.syncAccumulatingMaps();
                }
                catch (Exception e) {
                    logger.error("Error", e);
                }
            }
        });
        accumulatingMaps = new MapMaker().weakValues().makeMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccumulatingMap<K extends Serializable, V extends Serializable>
    extends HashMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 20090326L;
        transient Set<K> alteredKeys = new HashSet<K>();
        private transient String filename;

        public AccumulatingMap(String filename) {
            this.filename = filename;
            Map theMap = (Map)CacheManager.getFromFile(filename);
            if (theMap != null) {
                for (Map.Entry entry : theMap.entrySet()) {
                    super.put(entry.getKey(), entry.getValue());
                }
            }
        }

        @Override
        public synchronized V put(K k, V v) {
            this.alteredKeys.add(k);
            Serializable result = (Serializable)super.put(k, v);
            if ((double)this.alteredKeys.size() / (double)this.size() > 0.1) {
                this.mergeToDisk();
            }
            return (V)result;
        }

        @Override
        public synchronized void putAll(Map<? extends K, ? extends V> map) {
            this.alteredKeys.addAll(map.keySet());
            super.putAll(map);
        }

        private synchronized void clearAlteredKeys() {
            this.alteredKeys = new HashSet<K>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public synchronized void mergeToDisk() {
            block52: {
                FileLock lock;
                AbstractInterruptibleChannel channel;
                ObjectOutputStream oos;
                FileOutputStream fout;
                if (this.alteredKeys.isEmpty()) {
                    logger.warn("AccumulatingMap did not change: " + this.filename);
                } else {
                    block48: {
                        logger.warn("Writing AccumulatingMap: " + this.filename + ", " + this.size() + " entries, " + this.alteredKeys + " new.");
                        fout = null;
                        oos = null;
                        channel = null;
                        lock = null;
                        File cacheFile = new File(this.filename + ".new");
                        cacheFile.getParentFile().mkdirs();
                        fout = new FileOutputStream(cacheFile);
                        channel = fout.getChannel();
                        lock = ((FileChannel)channel).lock();
                        AccumulatingMap theMap = (AccumulatingMap)CacheManager.get(this.filename);
                        if (theMap == null) {
                            theMap = this;
                        } else {
                            this.defensiveBidirectionalSync(theMap);
                        }
                        oos = new ObjectOutputStream(fout);
                        oos.writeObject(theMap);
                        File oldFile = new File(this.filename);
                        if (!oldFile.exists() || oldFile.delete()) {
                            if (cacheFile.renameTo(oldFile)) {
                                this.clearAlteredKeys();
                            } else {
                                logger.warn("Can't rename merged cached file " + cacheFile + " to " + oldFile);
                            }
                            break block48;
                        }
                        logger.warn("Can't delete existing cache: " + oldFile);
                    }
                    Object var9_10 = null;
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    try {
                        if (channel != null) {
                            channel.close();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    try {
                        if (fout != null) {
                            fout.close();
                        }
                        break block52;
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                }
                break block52;
                {
                    catch (FileNotFoundException e) {
                        logger.warn("Can't merge cache, file not found: " + this.filename, e);
                        Object var9_11 = null;
                        try {
                            if (lock != null) {
                                lock.release();
                            }
                        }
                        catch (IOException e2) {
                            logger.error("Error", e2);
                        }
                        try {
                            if (channel != null) {
                                channel.close();
                            }
                        }
                        catch (IOException e2) {
                            logger.error("Error", e2);
                        }
                        try {
                            if (oos != null) {
                                oos.close();
                            }
                        }
                        catch (IOException e2) {
                            logger.error("Error", e2);
                        }
                        try {
                            if (fout != null) {
                                fout.close();
                            }
                            break block52;
                        }
                        catch (IOException e2) {
                            logger.error("Error", e2);
                        }
                        break block52;
                    }
                    catch (IOException e) {
                        logger.warn("Can't merge cache: " + this.filename, e);
                        Object var9_12 = null;
                        try {
                            if (lock != null) {
                                lock.release();
                            }
                        }
                        catch (IOException e2) {
                            logger.error("Error", e2);
                        }
                        try {
                            if (channel != null) {
                                channel.close();
                            }
                        }
                        catch (IOException e2) {
                            logger.error("Error", e2);
                        }
                        try {
                            if (oos != null) {
                                oos.close();
                            }
                        }
                        catch (IOException e2) {
                            logger.error("Error", e2);
                        }
                        try {
                            if (fout != null) {
                                fout.close();
                            }
                            break block52;
                        }
                        catch (IOException e2) {
                            logger.error("Error", e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    try {
                        if (channel != null) {
                            channel.close();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    try {
                        if (fout != null) {
                            fout.close();
                        }
                    }
                    catch (IOException e2) {
                        logger.error("Error", e2);
                    }
                    throw throwable;
                }
            }
        }

        private synchronized void defensiveBidirectionalSync(@NotNull AccumulatingMap<K, V> theMap) {
            for (Serializable alteredKey : this.alteredKeys) {
                Serializable cachedValue = (Serializable)theMap.get(alteredKey);
                Serializable newValue = (Serializable)this.get(alteredKey);
                if (cachedValue != null) {
                    if (cachedValue.equals(newValue)) continue;
                    throw new Error("Caches out of sync: " + this.filename + " for key " + alteredKey);
                }
                theMap.put(alteredKey, newValue);
            }
            this.clear();
            this.putAll(theMap);
        }
    }
}

