/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils;

import com.davidsoergel.dsutils.DSStringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;

public class DSClassUtils
extends ClassUtils {
    private static Map<Type, Type> wrapperPrimitiveMap = new HashMap<Type, Type>();

    public static Class[] getClasses(Object[] objects) {
        ArrayList result = new ArrayList();
        for (Object o : objects) {
            result.add(o.getClass());
        }
        return result.toArray(new Class[0]);
    }

    public static Constructor findConstructor(Class theClass, Class[] paramClasses) throws NoSuchMethodException {
        Object constr = null;
        Constructor<?>[] constrs = theClass.getConstructors();
        for (int i = 0; constr == null && i < constrs.length; ++i) {
            Class<?>[] paramTypes = constrs[i].getParameterTypes();
            if (paramTypes.length != paramClasses.length) continue;
            boolean candidate = true;
            for (int j = 0; j < paramTypes.length; ++j) {
                if (paramTypes[j].isPrimitive()) {
                    paramTypes[j] = DSClassUtils.primitiveToWrapper(paramTypes[j]);
                }
                if (DSClassUtils.isAssignable(paramClasses[j], paramTypes[j])) continue;
                candidate = false;
            }
            if (!candidate) continue;
            return constrs[i];
        }
        throw new NoSuchMethodException("" + theClass + " (" + DSStringUtils.join((Object[])paramClasses, ", ") + ")");
    }

    public static Type wrapperToPrimitive(Type t) {
        return wrapperPrimitiveMap.get(t);
    }

    static {
        wrapperPrimitiveMap.put((Type)((Object)Boolean.class), Boolean.TYPE);
        wrapperPrimitiveMap.put((Type)((Object)Byte.class), Byte.TYPE);
        wrapperPrimitiveMap.put((Type)((Object)Character.class), Character.TYPE);
        wrapperPrimitiveMap.put((Type)((Object)Short.class), Short.TYPE);
        wrapperPrimitiveMap.put((Type)((Object)Integer.class), Integer.TYPE);
        wrapperPrimitiveMap.put((Type)((Object)Long.class), Long.TYPE);
        wrapperPrimitiveMap.put((Type)((Object)Double.class), Double.TYPE);
        wrapperPrimitiveMap.put((Type)((Object)Float.class), Float.TYPE);
    }
}

