/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils;

import com.davidsoergel.dsutils.Labellable;
import com.davidsoergel.dsutils.collections.ConcurrentHashWeightedSet;
import com.davidsoergel.dsutils.collections.ImmutableHashWeightedSet;
import com.davidsoergel.dsutils.collections.MutableWeightedSet;
import com.davidsoergel.dsutils.collections.WeightedSet;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabellableImpl<T>
implements Labellable<T> {
    private static final Logger logger = Logger.getLogger(LabellableImpl.class);
    protected transient MutableWeightedSet<T> mutableWeightedLabels = new ConcurrentHashWeightedSet();
    private transient WeightedSet<T> immutableWeightedLabels;

    @Override
    public void doneLabelling() {
        if (this.mutableWeightedLabels == null) {
            logger.debug("doneLabelling was already called");
            return;
        }
        this.immutableWeightedLabels = new ImmutableHashWeightedSet<T>(this.mutableWeightedLabels);
        this.mutableWeightedLabels = null;
    }

    @Override
    @NotNull
    public WeightedSet<T> getImmutableWeightedLabels() {
        if (this.immutableWeightedLabels == null) {
            throw new Error("need to call doneLabelling before getImmutableWeightedLabels");
        }
        return this.immutableWeightedLabels;
    }

    @Override
    @NotNull
    public MutableWeightedSet<T> getMutableWeightedLabels() {
        if (this.mutableWeightedLabels == null) {
            throw new Error("Can't call getMutableWeightedLabels after doneLabelling");
        }
        return this.mutableWeightedLabels;
    }

    @Override
    public int getItemCount() {
        if (this.immutableWeightedLabels != null) {
            return this.immutableWeightedLabels.getItemCount();
        }
        return this.mutableWeightedLabels.getItemCount();
    }
}

