/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SmtpUtils {
    private static final Logger logger = Logger.getLogger(SmtpUtils.class);
    private static String emailHost;
    private static String emailFrom;
    private static String emailTo;
    private static String emailSubject;

    public static String getEmailHost() {
        return emailHost;
    }

    public static void setEmailHost(String s) {
        emailHost = s;
    }

    public static void setEmailFrom(String s) {
        emailFrom = s;
    }

    public static void setEmailTo(String s) {
        emailTo = s;
    }

    public static void setEmailSubject(String s) {
        emailSubject = s;
    }

    public static void sendEmail(String s) {
        SmtpUtils.sendEmail(emailHost, emailFrom, emailTo, emailSubject, s);
    }

    public static void sendEmail(String from, String to, String subject, String s) {
        SmtpUtils.sendEmail(emailHost, from, to, subject, s);
    }

    public static void sendEmail(String mailhost, String from, String to, String subject, String message) {
        Socket mailSocket = null;
        BufferedReader is = null;
        PrintStream os = null;
        try {
            mailSocket = new Socket(mailhost, 25);
            os = new PrintStream(mailSocket.getOutputStream());
            is = new BufferedReader(new InputStreamReader(mailSocket.getInputStream()));
            String servResponse = is.readLine();
            if (servResponse == null || servResponse.startsWith("4")) {
                throw new Exception(servResponse);
            }
            os.print("HELO TownError\r\n");
            servResponse = is.readLine();
            String lineOut = "MAIL FROM: " + from;
            os.print(lineOut + "\r\n");
            servResponse = is.readLine();
            if (servResponse == null || servResponse.startsWith("5")) {
                throw new Exception(servResponse);
            }
            StringTokenizer theTokenizer = new StringTokenizer(to, " ,");
            while (theTokenizer.hasMoreTokens()) {
                String theToken = theTokenizer.nextToken();
                lineOut = "RCPT TO: <" + theToken + ">";
                os.print(lineOut + "\r\n");
                servResponse = is.readLine();
                if (servResponse != null && !servResponse.startsWith("5")) continue;
                throw new Exception(servResponse);
            }
            os.print("DATA\r\n");
            servResponse = is.readLine();
            if (servResponse == null || servResponse.startsWith("5")) {
                throw new Exception(servResponse);
            }
            os.print("To: " + to + "\r\n");
            os.print("From: " + from + "\r\n");
            os.print("Subject: " + subject + "\r\n");
            os.print("Date: " + new Date() + "\r\n");
            os.print("\r\n");
            message = SmtpUtils.fixCRLF(message);
            os.print(SmtpUtils.fixCRLF(message));
            os.print("\r\n.\r\n");
            os.flush();
            servResponse = is.readLine();
            if (servResponse == null || servResponse.startsWith("5")) {
                throw new Exception(servResponse);
            }
            os.print("quit\r\n");
            is.close();
            os.close();
            mailSocket.close();
            logger.info("\nException mailed to " + to);
        }
        catch (Exception e) {
            logger.error("Error", e);
            try {
                os.print("quit\r\n");
                is.close();
                os.close();
                mailSocket.close();
            }
            catch (Exception f) {
                logger.error("Error", f);
            }
        }
    }

    private static String fixCRLF(String s) {
        StringBuffer sb = new StringBuffer(s);
        int c = 0;
        if (logger.isTraceEnabled()) {
            logger.trace("BEFORE: " + sb.length());
        }
        c = sb.toString().indexOf(10, c);
        try {
            if (c == 0) {
                sb.insert(c, '\r');
                ++c;
                c = sb.toString().indexOf(10, c + 1);
            }
            while (c != -1) {
                if (sb.charAt(c - 1) != '\r') {
                    sb.insert(c, '\r');
                    ++c;
                }
                c = sb.toString().indexOf(10, c + 1);
                if (!logger.isTraceEnabled()) continue;
                logger.trace(c + ":" + sb.substring(c - 5 < 0 ? 0 : c - 5, c + 5 > sb.length() ? sb.length() : c + 5));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            logger.error("Couldn't fix LF -> CRLF at position " + c, e);
        }
        c = 0;
        c = sb.toString().indexOf(13, c);
        try {
            while (c != -1) {
                if (sb.charAt(c + 1) != '\n') {
                    sb.insert(c + 1, '\n');
                    ++c;
                }
                c = sb.toString().indexOf(13, c + 1);
                if (!logger.isTraceEnabled()) continue;
                logger.trace(c + ":" + sb.substring(c - 5 < 0 ? 0 : c - 5, c + 5));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            logger.trace("Couldn't fix CR -> CRLF at position " + c);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("AFTER: " + sb.length());
        }
        return sb.toString();
    }

    public static String normalizeCRLF(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s);
        int c = 0;
        c = sb.toString().indexOf(13, c);
        try {
            while (c != -1) {
                if (sb.charAt(c + 1) != '\n') {
                    sb.insert(c + 1, '\n');
                    ++c;
                }
                c = sb.toString().indexOf(13, c + 1);
                if (!logger.isTraceEnabled()) continue;
                logger.trace(c + ":" + sb.substring(c - 5 < 0 ? 0 : c - 5, c + 5));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            logger.error("Couldn't fix CR -> CRLF at position " + c);
        }
        c = 0;
        c = sb.toString().indexOf(13, c);
        try {
            while (c != -1) {
                sb.delete(c, c + 1);
                c = sb.toString().indexOf(13, c);
                if (!logger.isTraceEnabled()) continue;
                logger.trace(c + ":" + sb.substring(c - 5 < 0 ? 0 : c - 5, c + 5));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            logger.error("Couldn't remove CR at position " + c);
        }
        return sb.toString();
    }
}

