/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import com.davidsoergel.dsutils.collections.AbstractWeightedSet;
import com.davidsoergel.dsutils.collections.CollectionRuntimeException;
import com.davidsoergel.dsutils.collections.MutableWeightedSet;
import com.davidsoergel.dsutils.collections.WeightedSet;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentHashWeightedSet<T>
extends AbstractWeightedSet<T>
implements MutableWeightedSet<T> {
    private final Integer initialCapacity;

    public ConcurrentHashWeightedSet(Map<? extends T, Double> map, int items) {
        this.backingMap = new ConcurrentHashMap();
        this.initialCapacity = 16;
        this.itemCount = items;
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public ConcurrentHashWeightedSet(Map<? extends T, Double> map) {
        this.backingMap = new ConcurrentHashMap();
        this.initialCapacity = 16;
        this.itemCount = 1;
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public ConcurrentHashWeightedSet(Multiset<T> m) {
        this.backingMap = new ConcurrentHashMap();
        this.initialCapacity = 16;
        this.itemCount = m.size();
        for (T o : m.elementSet()) {
            this.add(o, (double)m.count(o));
        }
    }

    public ConcurrentHashWeightedSet(int initialCapacity) {
        this.backingMap = new ConcurrentHashMap();
        this.initialCapacity = initialCapacity;
        this.itemCount = 0;
    }

    public ConcurrentHashWeightedSet() {
        this.backingMap = new ConcurrentHashMap();
        this.initialCapacity = 16;
        this.itemCount = 0;
    }

    @Override
    public synchronized void clear() {
        this.backingMap = new HashMap(this.initialCapacity);
        this.itemCount = 0;
    }

    @Override
    public synchronized void addAll(WeightedSet<T> increment) {
        this.itemCount += increment.getItemCount();
        for (Map.Entry<T, Double> entry : increment.entrySet()) {
            Double val = (Double)this.backingMap.get(entry.getKey());
            if (val == null) {
                val = 0.0;
            }
            val = val + entry.getValue();
            this.backingMap.put(entry.getKey(), val);
        }
    }

    @Override
    public synchronized void addAll(WeightedSet<T> increment, double weight) {
        this.itemCount += increment.getItemCount();
        for (Map.Entry<T, Double> entry : increment.entrySet()) {
            Double val = (Double)this.backingMap.get(entry.getKey());
            if (val == null) {
                val = 0.0;
            }
            Double d = entry.getValue() * weight;
            val = val + d;
            this.backingMap.put(entry.getKey(), val);
        }
    }

    @Override
    public synchronized void removeAll(WeightedSet<T> increment) {
        this.itemCount -= increment.getItemCount();
        for (Map.Entry<T, Double> entry : increment.entrySet()) {
            Double val = (Double)this.backingMap.get(entry.getKey());
            if (val == null) {
                val = 0.0;
            }
            val = val - entry.getValue();
            this.backingMap.put(entry.getKey(), val);
        }
    }

    private void add(T key, double addVal) {
        Double val = (Double)this.backingMap.get(key);
        if (val == null) {
            val = 0.0;
        }
        val = val + addVal;
        this.backingMap.put(key, val);
    }

    private void put(T key, double val) {
        this.backingMap.put(key, val);
    }

    @Override
    public synchronized void add(Map<T, Double> weights) {
        this.add(weights, 1);
    }

    @Override
    public synchronized void add(Map<T, Double> weights, int items) {
        for (Map.Entry<T, Double> entry : weights.entrySet()) {
            this.add(entry.getKey(), entry.getValue() * (double)items);
        }
        this.itemCount += items;
    }

    @Override
    public synchronized void add(T key, double increment, int items) {
        this.add(key, increment * (double)items);
        this.itemCount += items;
    }

    @Override
    public synchronized void put(Map<T, Double> weights) {
        this.put(weights, 1);
    }

    @Override
    public synchronized void put(Map<T, Double> weights, int items) {
        for (Map.Entry<T, Double> entry : weights.entrySet()) {
            this.put(entry.getKey(), entry.getValue() * (double)items);
        }
        if (this.itemCount == 0) {
            this.itemCount = items;
        } else if (this.itemCount != items) {
            throw new CollectionRuntimeException("Can't update a HashWeightedSet with a different number of items");
        }
    }

    @Override
    public synchronized void put(T key, double increment, int items) {
        this.put(key, increment * (double)items);
        if (this.itemCount == 0) {
            this.itemCount = items;
        } else if (this.itemCount != items) {
            throw new CollectionRuntimeException("Can't update a HashWeightedSet with a different number of items");
        }
    }

    @Override
    public synchronized void remove(T key, double remVal) {
        Double val = (Double)this.backingMap.get(key);
        if (val == null) {
            val = 0.0;
        }
        val = val - remVal;
        this.backingMap.put(key, val);
    }
}

