/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import com.davidsoergel.dsutils.collections.OrderedPair;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentValueSortedMap<K extends Comparable<K>, V extends Comparable<V>>
implements Serializable {
    private static final Logger logger = Logger.getLogger(ConcurrentValueSortedMap.class);
    private final ConcurrentHashMap<K, V> map;
    private final ConcurrentSkipListSet<OrderedPair<K, V>> sortedPairs;

    public ConcurrentValueSortedMap(ConcurrentValueSortedMap<K, V> cloneFrom) {
        this.map = new ConcurrentHashMap<K, V>(cloneFrom.getMap());
        this.sortedPairs = cloneFrom.getSortedPairs().clone();
    }

    public ConcurrentValueSortedMap() {
        this.sortedPairs = new ConcurrentSkipListSet<OrderedPair>(new OrderedPair.ValuesPrimaryComparator());
        this.map = new ConcurrentHashMap();
    }

    public ConcurrentSkipListSet<OrderedPair<K, V>> getSortedPairs() {
        return this.sortedPairs;
    }

    public ConcurrentHashMap<K, V> getMap() {
        return this.map;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public K firstKey() {
        return (K)((Comparable)this.sortedPairs.first().getKey1());
    }

    public OrderedPair<K, V> firstPair() {
        return this.sortedPairs.first();
    }

    public V firstValue() {
        return (V)((Comparable)this.sortedPairs.first().getKey2());
    }

    public K lastKey() {
        return (K)((Comparable)this.sortedPairs.last().getKey1());
    }

    public OrderedPair<K, V> lastPair() {
        return this.sortedPairs.last();
    }

    public V lastValue() {
        return (V)((Comparable)this.sortedPairs.last().getKey2());
    }

    public V get(K key) {
        return (V)((Comparable)this.map.get(key));
    }

    public void put(K key, V val) {
        this.remove(key);
        this.map.put(key, val);
        this.sortedPairs.add(new OrderedPair<K, V>(key, val));
    }

    public synchronized void remove(K key) {
        Comparable val = (Comparable)this.map.get(key);
        if (val != null) {
            this.remove(key, val);
        }
    }

    public synchronized void remove(K key, V val) {
        Comparable removed = (Comparable)this.map.remove(key);
        assert (removed != null);
        boolean sortedRemoved = this.sortedPairs.remove(new OrderedPair<K, V>(key, val));
        assert (sortedRemoved);
    }

    private synchronized void sanityCheck() {
        assert (this.map.size() == this.sortedPairs.size());
    }

    public int size() {
        return this.sortedPairs.size();
    }

    public boolean isEmpty() {
        return this.sortedPairs.isEmpty();
    }

    public ConcurrentLinkedQueue<Map.Entry<K, V>> entriesQueue() {
        ConcurrentLinkedQueue<Map.Entry<K, V>> result = new ConcurrentLinkedQueue<Map.Entry<K, V>>();
        result.addAll(this.map.entrySet());
        return result;
    }
}

