/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import com.davidsoergel.dsutils.collections.InsertionTrackingSet;
import com.davidsoergel.dsutils.collections.OrderedPair;
import com.davidsoergel.dsutils.collections.SortedSymmetric2dBiMap;
import com.davidsoergel.dsutils.collections.SortedSymmetric2dBiMapWithDefault;
import com.davidsoergel.dsutils.collections.UnorderedPair;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedSymmetric2dBiMapWithDefault<K extends Comparable<K> & Serializable, V extends Comparable<V> & Serializable>
implements SortedSymmetric2dBiMap<K, V> {
    private static final Logger logger = Logger.getLogger(IndexedSymmetric2dBiMapWithDefault.class);
    protected InsertionTrackingSet<K> keys;
    protected SortedSymmetric2dBiMapWithDefault<Integer, V> underlyingIntMap;

    public IndexedSymmetric2dBiMapWithDefault(V defaultValue) {
        this.underlyingIntMap = new SortedSymmetric2dBiMapWithDefault(defaultValue);
        this.keys = new InsertionTrackingSet();
    }

    public IndexedSymmetric2dBiMapWithDefault() {
        this.underlyingIntMap = new SortedSymmetric2dBiMapWithDefault();
        this.keys = new InsertionTrackingSet();
    }

    public IndexedSymmetric2dBiMapWithDefault(IndexedSymmetric2dBiMapWithDefault<K, V> cloneFrom) {
        this.setDefaultValue(cloneFrom.getDefaultValue());
        this.keys = new InsertionTrackingSet<K>(cloneFrom.keys);
        this.underlyingIntMap = new SortedSymmetric2dBiMapWithDefault<Integer, V>(cloneFrom.underlyingIntMap);
    }

    public IndexedSymmetric2dBiMapWithDefault(V defaultValue, Collection<K> keys) {
        this.underlyingIntMap = new SortedSymmetric2dBiMapWithDefault(defaultValue);
        this.keys = new InsertionTrackingSet<K>(keys);
    }

    public void setDefaultValue(V defaultValue) {
        this.underlyingIntMap.setDefaultValue(defaultValue);
    }

    public V getDefaultValue() {
        return this.underlyingIntMap.getDefaultValue();
    }

    @Override
    public K getKey1WithSmallestValue() {
        return (K)((Comparable)this.keys.get((Integer)this.underlyingIntMap.getKey1WithSmallestValue()));
    }

    @Override
    public K getKey2WithSmallestValue() {
        return (K)((Comparable)this.keys.get((Integer)this.underlyingIntMap.getKey2WithSmallestValue()));
    }

    @Override
    public synchronized OrderedPair<UnorderedPair<K>, V> getKeyPairAndSmallestValue() {
        OrderedPair op = this.underlyingIntMap.getKeyPairAndSmallestValue();
        UnorderedPair p = op.getKey1();
        Comparable id1 = (Comparable)this.keys.get((Integer)p.getKey1());
        Comparable id2 = (Comparable)this.keys.get((Integer)p.getKey2());
        return new OrderedPair(new UnorderedPair<Comparable>(id1, id2), op.getKey2());
    }

    @Override
    public synchronized UnorderedPair<K> getKeyPairWithSmallestValue() {
        UnorderedPair p = this.underlyingIntMap.getKeyPairWithSmallestValue();
        return new UnorderedPair<Comparable>((Comparable)this.keys.get((Integer)p.getKey1()), (Comparable)this.keys.get((Integer)p.getKey2()));
    }

    @Override
    public V getSmallestValue() {
        return this.underlyingIntMap.getSmallestValue();
    }

    @Override
    public V get(K key1, K key2) {
        return this.underlyingIntMap.get(this.keys.indexOf(key1), this.keys.indexOf(key2));
    }

    @Override
    public Collection<K> getKeys() {
        return this.keys;
    }

    @Override
    public int numPairs() {
        return this.underlyingIntMap.numPairs();
    }

    public boolean isEmpty() {
        return this.underlyingIntMap.isEmpty();
    }

    public V get(UnorderedPair<K> keypair) {
        return this.underlyingIntMap.get(this.keys.indexOf(keypair.getKey1()), this.keys.indexOf(keypair.getKey2()));
    }

    public void put(UnorderedPair<K> keypair, V d) {
        Integer i1 = this.keys.indexOfWithAdd(keypair.getKey1());
        Integer i2 = this.keys.indexOfWithAdd(keypair.getKey2());
        this.underlyingIntMap.put(i1, i2, d);
    }

    @Override
    public void put(K key1, K key2, V d) {
        Integer i1 = this.keys.indexOfWithAdd(key1);
        Integer i2 = this.keys.indexOfWithAdd(key2);
        this.underlyingIntMap.put(i1, i2, d);
    }

    @Override
    public int numKeys() {
        return this.keys.size();
    }

    @Override
    public void addKey(K key1) {
        this.keys.add(key1);
    }

    @Override
    public void putAll(Map<UnorderedPair<K>, V> map) {
        for (Map.Entry<UnorderedPair<K>, V> entry : map.entrySet()) {
            UnorderedPair<K> p = entry.getKey();
            Comparable v = (Comparable)entry.getValue();
            this.put(p.getKey1(), p.getKey2(), v);
        }
    }

    public void putAllInt(Map<UnorderedPair<Integer>, V> map) {
        for (Map.Entry<UnorderedPair<Integer>, V> entry : map.entrySet()) {
            UnorderedPair<Integer> p = entry.getKey();
            Comparable v = (Comparable)entry.getValue();
            this.underlyingIntMap.put(p, v);
        }
    }

    public void putInt(UnorderedPair<Integer> pair, V v) {
        this.underlyingIntMap.put(pair, v);
    }

    @Override
    public void removeAll(Collection<K> keys) {
        for (Comparable key : keys) {
            this.remove(key);
        }
    }

    @Override
    public synchronized int remove(K b) {
        Integer i = this.keys.indexOf(b);
        if (i != null) {
            int removed = this.underlyingIntMap.remove(i);
            boolean keyRemoved = this.keys.remove(b);
            assert (keyRemoved);
            return removed;
        }
        assert (this.keys.indexOf(b) == null);
        return 0;
    }

    @Override
    public Set<Map.Entry<UnorderedPair<K>, V>> entrySet() {
        throw new NotImplementedException();
    }

    public int getNextId() {
        return this.keys.getNextId();
    }

    public Set<Iterator<Map.Entry<UnorderedPair<K>, V>>> entryBlockIterators(int i) {
        throw new NotImplementedException();
    }

    public ConcurrentLinkedQueue<Map.Entry<UnorderedPair<Integer>, V>> integerEntriesQueue() {
        return this.underlyingIntMap.entriesQueue();
    }

    public void sanityCheck() {
        this.underlyingIntMap.sanityCheck();
    }
}

