/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertionTrackingSet<T>
extends AbstractSet<T>
implements Serializable {
    private BiMap<T, Integer> contents = HashBiMap.create();
    private int nextIndex = 0;

    public InsertionTrackingSet() {
    }

    public InsertionTrackingSet(Collection<T> c) {
        this.addAll(c);
    }

    public synchronized T get(Integer index) {
        return (T)this.contents.inverse().get(index);
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return this.contents.keySet().iterator();
    }

    @Override
    public synchronized int size() {
        return this.contents.size();
    }

    @Override
    public synchronized boolean add(T t) {
        try {
            this.contents.put(t, this.nextIndex);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        ++this.nextIndex;
        return true;
    }

    public synchronized void put(T t, Integer index) {
        if (this.contents.containsKey(t) || this.contents.containsValue(index)) {
            throw new IllegalArgumentException();
        }
        this.contents.put(t, index);
        this.nextIndex = Math.max(this.nextIndex, index + 1);
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.contents.remove(o) != null;
    }

    public synchronized Integer indexOf(T key1) {
        return (Integer)this.contents.get(key1);
    }

    public synchronized Integer indexOfWithAdd(T key1) {
        Integer result = this.indexOf(key1);
        if (result == null) {
            this.add(key1);
            result = this.nextIndex - 1;
        }
        return result;
    }

    public synchronized int getNextId() {
        return this.nextIndex;
    }

    public Collection<Integer> getIndexes() {
        return this.contents.values();
    }
}

