/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import com.davidsoergel.dsutils.collections.OrderedPair;
import java.util.Iterator;
import org.apache.commons.lang.NotImplementedException;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedPairIterator<A, B>
implements Iterator<OrderedPair<A, B>> {
    private final Iterator<A> iterA;
    private final Iterable<B> iterableB;
    private Iterator<B> iterB;
    private A aTrav = null;

    public OrderedPairIterator(@NotNull Iterator<A> iterA, Iterable<B> iterableB) {
        this.iterA = iterA;
        this.iterableB = iterableB;
    }

    public OrderedPairIterator(@NotNull Iterable<A> iterableA, Iterable<B> iterableB) {
        this(iterableA.iterator(), iterableB);
    }

    @Override
    public boolean hasNext() {
        boolean canAdvanceB = this.aTrav != null && this.iterB.hasNext();
        return canAdvanceB || this.advanceA();
    }

    private boolean advanceA() {
        this.aTrav = this.iterA.next();
        this.iterB = this.iterableB.iterator();
        boolean canAdvanceB = this.aTrav != null && this.iterB.hasNext();
        return canAdvanceB;
    }

    @Override
    public OrderedPair<A, B> next() {
        if (!this.hasNext()) {
            return null;
        }
        B bTrav = this.iterB.next();
        assert (this.aTrav != null && bTrav != null);
        return new OrderedPair<A, B>(this.aTrav, bTrav);
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }
}

