/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import com.davidsoergel.dsutils.collections.ConcurrentValueSortedMap;
import com.davidsoergel.dsutils.collections.OrderedPair;
import com.davidsoergel.dsutils.collections.SortedSymmetric2dBiMap;
import com.davidsoergel.dsutils.collections.UnorderedPair;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedSymmetric2dBiMapImpl<K extends Comparable<K> & Serializable, V extends Comparable<V> & Serializable>
implements SortedSymmetric2dBiMap<K, V> {
    private static final Logger logger = Logger.getLogger(SortedSymmetric2dBiMapImpl.class);
    protected SimpleMultiMap<K, UnorderedPair<K>> keyToKeyPairs = new SimpleMultiMap();
    public ConcurrentValueSortedMap<UnorderedPair<K>, V> keyPairToValueSorted = new ConcurrentValueSortedMap();

    public SortedSymmetric2dBiMapImpl(SortedSymmetric2dBiMapImpl<K, V> cloneFrom) {
        this.keyToKeyPairs = new SimpleMultiMap<K, UnorderedPair<K>>(cloneFrom.keyToKeyPairs);
        this.keyPairToValueSorted = new ConcurrentValueSortedMap<UnorderedPair<UnorderedPair<K>>, V>(cloneFrom.keyPairToValueSorted);
    }

    public SortedSymmetric2dBiMapImpl() {
    }

    protected V get(UnorderedPair<K> keyPair) {
        return this.keyPairToValueSorted.get(keyPair);
    }

    @Override
    public V get(K key1, K key2) {
        return this.get(new UnorderedPair<K>(key1, key2));
    }

    @Override
    public Set<K> getKeys() {
        return this.keyToKeyPairs.keySet();
    }

    @Override
    public K getKey1WithSmallestValue() {
        return this.getKeyPairWithSmallestValue().getKey1();
    }

    @Override
    public K getKey2WithSmallestValue() {
        return this.getKeyPairWithSmallestValue().getKey2();
    }

    @Override
    public synchronized OrderedPair<UnorderedPair<K>, V> getKeyPairAndSmallestValue() {
        return this.keyPairToValueSorted.firstPair();
    }

    @Override
    public UnorderedPair<K> getKeyPairWithSmallestValue() {
        return this.keyPairToValueSorted.firstKey();
    }

    @Override
    public V getSmallestValue() {
        return this.keyPairToValueSorted.firstValue();
    }

    public void matrixCompleteSanityCheck() {
        int numKeys = this.numKeys();
        int numKeyPairs = this.keyPairToValueSorted.size();
        assert (numKeyPairs == numKeys * (numKeys - 1) / 2);
    }

    @Override
    public int numPairs() {
        return this.keyPairToValueSorted.size();
    }

    public boolean isEmpty() {
        return this.keyPairToValueSorted.isEmpty();
    }

    @Override
    public void put(K key1, K key2, V d) {
        assert (!key1.equals(key2));
        UnorderedPair<K> pair = new UnorderedPair<K>(key1, key2);
        this.keyPairToValueSorted.put(pair, d);
        this.keyToKeyPairs.put((Serializable)key1, pair);
        this.keyToKeyPairs.put((Serializable)key2, pair);
    }

    protected void put(UnorderedPair<K> keyPair, V d) {
        this.keyPairToValueSorted.put(keyPair, d);
        this.keyToKeyPairs.put((Serializable)keyPair.getKey1(), keyPair);
        this.keyToKeyPairs.put((Serializable)keyPair.getKey2(), keyPair);
    }

    protected synchronized void sanityCheck() {
        int numKeys = this.numKeys();
        int numKeyPairs = this.keyPairToValueSorted.size();
        assert (numKeyPairs <= numKeys * (numKeys - 1) / 2);
    }

    @Override
    public synchronized int numKeys() {
        return this.keyToKeyPairs.numKeys();
    }

    @Override
    public synchronized void addKey(K key1) {
        this.keyToKeyPairs.get((Serializable)key1);
    }

    @Override
    public synchronized void putAll(Map<UnorderedPair<K>, V> result) {
        for (Map.Entry<UnorderedPair<K>, V> entry : result.entrySet()) {
            UnorderedPair<K> pair = entry.getKey();
            K key1 = pair.getKey1();
            K key2 = pair.getKey2();
            assert (!key1.equals(key2));
            this.keyToKeyPairs.put((Serializable)key1, pair);
            this.keyToKeyPairs.put((Serializable)key2, pair);
            this.keyPairToValueSorted.put(pair, (Comparable)entry.getValue());
        }
    }

    @Override
    public synchronized void removeAll(Collection<K> keys) {
        for (Comparable key : keys) {
            this.remove(key);
        }
    }

    @Override
    public synchronized int remove(K b) {
        int removed = 0;
        HashSet<UnorderedPair<K>> obsoletePairs = new HashSet<UnorderedPair<K>>(this.keyToKeyPairs.get((Serializable)b));
        for (UnorderedPair unorderedPair : obsoletePairs) {
            ++removed;
            this.keyPairToValueSorted.remove(unorderedPair);
            Object a = unorderedPair.getKey1();
            if (a.equals(b)) {
                a = unorderedPair.getKey2();
                assert (!a.equals(b));
            }
            this.keyToKeyPairs.get((Serializable)a).remove(unorderedPair);
        }
        this.keyToKeyPairs.removeAll((Serializable)b);
        return removed;
    }

    @Override
    public Set<Map.Entry<UnorderedPair<K>, V>> entrySet() {
        return this.keyPairToValueSorted.entrySet();
    }

    public void removalSanityCheck(K b, Collection<K> keys) {
        assert (!this.getKeys().contains(b));
        for (Map.Entry<UnorderedPair<K>, V> entry : this.keyPairToValueSorted.entrySet()) {
            K k1 = entry.getKey().getKey1();
            K k2 = entry.getKey().getKey2();
            assert (!k1.equals(b));
            assert (!k2.equals(b));
            assert (keys.contains(k1));
            assert (keys.contains(k2));
        }
    }

    public ConcurrentLinkedQueue<Map.Entry<UnorderedPair<K>, V>> entriesQueue() {
        return this.keyPairToValueSorted.entriesQueue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimpleMultiMap<X extends Serializable, Y extends Serializable>
    implements Serializable {
        private Map<X, Set<Y>> contents = new ConcurrentHashMap<X, Set<Y>>();

        public SimpleMultiMap() {
        }

        public SimpleMultiMap(SimpleMultiMap<X, Y> cloneFrom) {
            this.contents.putAll(cloneFrom.contents);
        }

        public Collection<Y> get(X a) {
            Set<Y> ys = this.contents.get(a);
            if (ys == null) {
                ys = new ConcurrentSkipListSet<Y>();
                this.contents.put(a, ys);
            }
            return ys;
        }

        public Set<X> keySet() {
            return this.contents.keySet();
        }

        public int numKeys() {
            return this.contents.size();
        }

        public void put(X key1, Y val) {
            this.get(key1).add(val);
        }

        public void removeAll(X b) {
            this.contents.remove(b);
        }
    }
}

