/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import com.davidsoergel.dsutils.collections.UnorderedPair;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang.NotImplementedException;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnorderedPairIterator<A extends Comparable<A>>
implements Iterator<UnorderedPair<A>> {
    private final Iterator<A> iterA;
    private final Iterable<A> iterableB;
    private Iterator<A> iterB;
    private A aTrav = null;
    private A bTrav = null;

    public UnorderedPairIterator(@NotNull Iterator<A> iterA, Iterable<A> iterableB) {
        this.iterA = iterA;
        this.iterableB = iterableB;
    }

    public UnorderedPairIterator(@NotNull Iterable<A> iterableA, Iterable<A> iterableB) {
        this(iterableA.iterator(), iterableB);
    }

    @Override
    public synchronized boolean hasNext() {
        boolean canAdvanceB = this.aTrav != null && this.iterB.hasNext();
        return canAdvanceB || this.iterA.hasNext();
    }

    private synchronized boolean advanceA() {
        this.aTrav = (Comparable)this.iterA.next();
        this.iterB = this.iterableB.iterator();
        boolean canAdvanceB = this.aTrav != null && this.iterB.hasNext();
        return canAdvanceB;
    }

    private synchronized boolean advanceB() {
        if (!(this.iterB != null && this.iterB.hasNext() || this.advanceA())) {
            return false;
        }
        this.bTrav = (Comparable)this.iterB.next();
        assert (this.bTrav != null);
        return true;
    }

    @Override
    @NotNull
    public synchronized UnorderedPair<A> next() {
        while (this.advanceB()) {
            assert (this.aTrav != null && this.bTrav != null);
            if (this.aTrav.compareTo(this.bTrav) >= 0) continue;
            return new UnorderedPair<A>(this.aTrav, this.bTrav);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }
}

