/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class);

    public static boolean move(File oldFile, File newFile) {
        if (!oldFile.renameTo(newFile)) {
            int bufsize = 1024;
            if (!FileUtils.bufferedCopy(oldFile, newFile, bufsize)) {
                return false;
            }
            if (!oldFile.delete()) {
                logger.error("Can't delete " + oldFile + " after copy");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean bufferedCopy(File origFile, File copyFile, int buffSize) {
        byte[] buff = new byte[buffSize];
        try {
            FileInputStream fis = new FileInputStream(origFile);
            FileOutputStream fos = new FileOutputStream(copyFile);
            try {
                int bytes = 0;
                while ((bytes = fis.read(buff)) > -1) {
                    fos.write(buff, 0, bytes);
                }
            }
            finally {
                fis.close();
                fos.close();
            }
        }
        catch (IOException e) {
            logger.error("Error", e);
            return false;
        }
        return true;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                logger.error("Unable to delete file: " + file.getAbsolutePath() + " while trying to delete " + path.getAbsolutePath());
            }
        }
        return path.delete();
    }

    public static List<File> getFilesWithNames(String root, String[] filenames) {
        ArrayList<File> files = new ArrayList<File>();
        if (filenames != null) {
            try {
                for (String f : filenames) {
                    if (f.endsWith("*")) {
                        String dirname = f.substring(0, f.lastIndexOf(File.separator));
                        File dir = new File(root + File.separator + dirname);
                        final String prefix = f.substring(f.lastIndexOf(File.separator) + 1, f.length() - 1);
                        if (dir.list() == null || dir.listFiles() == null) {
                            logger.error("Directory list is empty: " + dir.getCanonicalPath());
                            logger.debug("is directory: " + dir.isDirectory());
                        }
                        for (File r : dir.listFiles(new FilenameFilter(){

                            public boolean accept(File file, String string) {
                                return string.startsWith(prefix);
                            }
                        })) {
                            files.add(r);
                        }
                        continue;
                    }
                    files.add(new File(root + File.separator + f));
                }
            }
            catch (Exception e) {
                logger.error("Error", e);
                throw new RuntimeException("trouble listing files.", e);
            }
        }
        return files;
    }

    public static File getDirectory(String name) throws IOException {
        File dir = new File(name);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + name);
        }
        return dir;
    }
}

