/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringSetIntMapReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Set<Integer>> read(String filename) throws IOException {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        URL res = threadClassLoader.getResource(filename);
        if (res == null) {
            File f = new File(filename);
            if (f.exists()) {
                res = f.toURI().toURL();
            } else {
                throw new FileNotFoundException("File not found: " + filename);
            }
        }
        InputStream is = res.openStream();
        HashMap<String, Set<Integer>> result = new HashMap<String, Set<Integer>>();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            int i = 0;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                String[] numbers = line.split("\t");
                try {
                    String key = numbers[0];
                    Integer value = new Integer(numbers[1]);
                    HashSet<Integer> resultSet = (HashSet<Integer>)result.get(key);
                    if (resultSet == null) {
                        resultSet = new HashSet<Integer>();
                        result.put(key, resultSet);
                    }
                    resultSet.add(value);
                    ++i;
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("Could not read line " + i + " of " + filename + ": " + line);
                }
            }
            HashMap<String, Set<Integer>> hashMap = result;
            return hashMap;
        }
        finally {
            br.close();
        }
    }
}

