/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.increment;

import com.davidsoergel.dsutils.increment.Incrementor;
import org.apache.log4j.Logger;

public class BasicIncrementor
extends Incrementor {
    private static final Logger logger = Logger.getLogger(BasicIncrementor.class);
    int i = 0;
    int max = 0;
    String note;

    public BasicIncrementor(String clientName, String initialNote) {
        super(clientName);
        this.note = initialNote;
    }

    public void increment() {
        ++this.i;
        this.fireIncrementableUpdatedEvent(this.i, this.max);
    }

    public void done() {
        this.fireIncrementableUpdatedEvent(this.max, this.max);
    }

    public void setMaximum(int i) {
        this.max = i;
        this.fireIncrementableUpdatedEvent(i, this.max);
    }

    public void setNote(String n) {
        this.note = n;
        this.fireIncrementableNoteEvent(this.note);
    }

    public void incrementMaximum(int length) {
        this.max += length;
        this.fireIncrementableUpdatedEvent(this.i, this.max);
    }

    public int getCount() {
        return this.i;
    }

    public int getMax() {
        return this.max;
    }

    public void resetWithNote(String s) {
        this.i = 0;
        this.note = s;
        this.fireIncrementableUpdatedEvent(this.i, this.max);
        this.fireIncrementableNoteEvent(this.note);
    }
}

