/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.increment;

import com.davidsoergel.dsutils.increment.Incrementor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ConcurrentIncrementor
extends Incrementor {
    private static final Logger logger = Logger.getLogger(ConcurrentIncrementor.class);
    AtomicInteger i = new AtomicInteger(0);
    AtomicInteger max = new AtomicInteger(0);
    String note;
    final Boolean sync = false;

    public ConcurrentIncrementor(String clientName, String initialNote) {
        super(clientName);
        this.note = initialNote;
    }

    public void increment() {
        int x = this.i.incrementAndGet();
        this.fireIncrementableUpdatedEvent(x, this.max.get());
    }

    public void done() {
        this.fireIncrementableUpdatedEvent(this.max.get(), this.max.get());
    }

    public void setMaximum(int m) {
        this.max.set(m);
        this.fireIncrementableUpdatedEvent(this.i.get(), this.max.get());
    }

    public int getMax() {
        return this.max.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(String n) {
        Boolean bl = this.sync;
        synchronized (bl) {
            this.note = n;
        }
        this.fireIncrementableNoteEvent(this.note);
    }

    public void incrementMaximum(int length) {
        int x = this.max.addAndGet(length);
        this.fireIncrementableUpdatedEvent(this.i.get(), x);
    }

    public int getCount() {
        return this.i.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetWithNote(String s) {
        this.i.set(0);
        Boolean bl = this.sync;
        synchronized (bl) {
            this.note = s;
        }
        this.fireIncrementableUpdatedEvent(this.i.get(), this.max.get());
        this.fireIncrementableNoteEvent(this.note);
    }

    public String getNote() {
        return this.note;
    }
}

