/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.math;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class ArrayInterpolatingFunctionCache {
    Method method;
    float maxError;
    InterpolationInterval[] intervals = new InterpolationInterval[1];
    int evalCount;
    int notHits;

    public ArrayInterpolatingFunctionCache(Method method, float maxError, float minX, float maxX) {
        this.method = method;
        this.maxError = maxError;
        InterpolationInterval i = new InterpolationInterval(minX, maxX);
        try {
            i.cielY = ((Double)method.invoke(null, Float.valueOf(maxX))).floatValue();
        }
        catch (Exception e) {
            throw new Error(e);
        }
        this.intervals[0] = i;
    }

    public String perfString() {
        return "" + this.intervals.length + " intervals, " + this.evalCount + " evaluations, " + (this.evalCount - this.notHits) + " hits (" + (float)(this.evalCount - this.notHits) / (float)this.evalCount + "%)";
    }

    public float evaluate(float x) {
        int index = Arrays.binarySearch(this.intervals, new InterpolationInterval(x));
        if (index < 0) {
            throw new Error("Argument outside allowable range");
        }
        return this.intervals[index].interpolate(x);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InterpolationInterval
    implements Comparable<InterpolationInterval> {
        private final float floorX;
        private float cielX;
        private float floorY;
        private float cielY;
        private float slope;
        private boolean smooth;

        private InterpolationInterval(float floor) {
            this.cielX = this.floorX = floor == -0.0f ? 0.0f : floor;
        }

        private InterpolationInterval(float floor, float cielX) {
            this(floor);
            this.cielX = cielX;
            try {
                this.floorY = ((Double)arrayInterpolatingFunctionCache.method.invoke(null, Float.valueOf(this.floorX))).floatValue();
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }

        public String toString() {
            return "InterpolationInterval{" + this.floorX + "->" + this.cielX + " = " + this.floorY + " + " + this.slope + " * x " + (this.smooth ? "SMOOTH" : "") + '}';
        }

        @Override
        public int compareTo(InterpolationInterval o) {
            if (this.floorX < o.cielX && o.floorX < this.cielX) {
                return 0;
            }
            return Float.compare(this.floorX, o.floorX);
        }

        public boolean equals(Object obj) {
            InterpolationInterval o = (InterpolationInterval)obj;
            return !(this.floorX >= o.cielX) && !(o.floorX >= this.cielX);
        }

        public int hashCode() {
            return Float.floatToIntBits(this.floorX);
        }

        public int intValue() {
            return (int)this.floorX;
        }

        public long longValue() {
            return (long)this.floorX;
        }

        public float floatValue() {
            return this.floorX;
        }

        public double doubleValue() {
            return this.floorX;
        }

        public float interpolate(float x) {
            ++ArrayInterpolatingFunctionCache.this.evalCount;
            if (!this.smooth) {
                ++ArrayInterpolatingFunctionCache.this.notHits;
                float halfExtent = (this.cielX - this.floorX) / 2.0f;
                float midX = this.floorX + halfExtent;
                InterpolationInterval right = new InterpolationInterval(midX, this.cielX);
                right.cielY = this.cielY;
                right.slope = this.slope;
                this.cielX = midX;
                this.cielY = right.floorY;
                this.updateSlopeAndSmooth();
                right.updateSlopeAndSmooth();
                int index = Arrays.binarySearch(ArrayInterpolatingFunctionCache.this.intervals, right);
                index = -index - 1;
                ArrayList<InterpolationInterval> tmp = new ArrayList<InterpolationInterval>(Arrays.asList(ArrayInterpolatingFunctionCache.this.intervals));
                tmp.add(index, right);
                ArrayInterpolatingFunctionCache.this.intervals = tmp.toArray(ArrayInterpolatingFunctionCache.this.intervals);
                if (x <= right.floorX) {
                    return this.interpolate(x);
                }
                return right.interpolate(x);
            }
            return this.predict(x);
        }

        public void updateSlopeAndSmooth() {
            float predictedCielY = this.predict(this.cielX);
            float absoluteError = predictedCielY - this.cielY;
            if (Math.abs(absoluteError) < ArrayInterpolatingFunctionCache.this.maxError) {
                this.smooth = true;
            }
            this.slope = (this.cielY - this.floorY) / (this.cielX - this.floorX);
        }

        private float predict(float x) {
            return this.floorY + (x - this.floorX) * this.slope;
        }
    }
}

