/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.math;

import com.davidsoergel.dsutils.math.MathUtils;
import com.davidsoergel.dsutils.math.SafeIntegerArithmetic;
import java.io.Serializable;

public class LongRational
extends Number
implements Comparable,
Serializable {
    long numerator;
    long denominator;

    public LongRational() {
    }

    public static int overflowSafeCompare(LongRational ab, LongRational cd) {
        if (ab.equals(cd)) {
            return 0;
        }
        long a = ab.numerator;
        long d = cd.denominator;
        long b = ab.denominator;
        long c = cd.numerator;
        while (true) {
            long n = a / c;
            long m = b / d;
            n = (n = Math.min(n, m)) == 0L ? 1L : Math.min(Math.min(n, Long.MAX_VALUE / c), Long.MAX_VALUE / d);
            long x = a - n * c;
            long y = b - n * d;
            if (x > 0L && y < 0L) {
                return 1;
            }
            if (x < 0L && y > 0L) {
                return -1;
            }
            if (x < 0L && y < 0L) {
                b = d;
                a = c;
                d = -y;
                c = -x;
                continue;
            }
            if (x > 0L && y > 0L) {
                a = d;
                d = x;
                b = c;
                c = y;
                continue;
            }
            if (x == 0L) {
                return Long.valueOf(-y).compareTo(0L);
            }
            if (y == 0L) {
                return Long.valueOf(x).compareTo(0L);
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongRational that = (LongRational)o;
        if (this.denominator != that.denominator) {
            return false;
        }
        return this.numerator == that.numerator;
    }

    private static LongRational minus(LongRational a, LongRational b) {
        long denominatorGCD = MathUtils.GCD(a.denominator, b.denominator);
        long aFactor = b.denominator / denominatorGCD;
        long bFactor = a.denominator / denominatorGCD;
        long denom = SafeIntegerArithmetic.mul(a.denominator, aFactor);
        long aNum = SafeIntegerArithmetic.mul(a.numerator, aFactor);
        long bNum = SafeIntegerArithmetic.mul(b.numerator, bFactor);
        return new LongRational(aNum - bNum, denom);
    }

    public static LongRational mediant(LongRational a, LongRational b) {
        return new LongRational(a.numerator + b.numerator, a.denominator + b.denominator);
    }

    public LongRational(Long numerator, Long denominator) {
        this((long)numerator, (long)denominator);
    }

    public LongRational(long numerator, long denominator) {
        long num = numerator;
        long den = denominator;
        if (den == 0L) {
            if (num == 1L) {
                den = 1L;
            } else {
                throw new ArithmeticException("Division by zero when constructing new LongRational");
            }
        }
        long gcd = MathUtils.GCD(num, den);
        this.numerator = num / gcd;
        this.denominator = den / gcd;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public int hashCode() {
        int result = (int)(this.numerator ^ this.numerator >>> 32);
        result = 31 * result + (int)(this.denominator ^ this.denominator >>> 32);
        return result;
    }

    public String toString() {
        return "" + this.numerator + "/" + this.denominator;
    }

    public int compareTo(Object o) {
        LongRational lro = (LongRational)o;
        int result = new Double(this.doubleValue()).compareTo(lro.doubleValue());
        if (result == 0) {
            return LongRational.overflowSafeCompare(this, lro);
        }
        return result;
    }

    private int compareToZero() {
        if (this.numerator == 0L) {
            return 0;
        }
        if (this.denominator > 0L) {
            return this.numerator < 0L ? -1 : 1;
        }
        return this.numerator > 0L ? -1 : 1;
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public int intValue() {
        return (int)this.doubleValue();
    }

    public long longValue() {
        return (long)this.doubleValue();
    }

    public LongRational minus(LongRational b) {
        return LongRational.minus(this, b);
    }
}

