/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.math;

public class SafeIntegerArithmetic {
    public static final PrimTypeIndTy ByteTy = PrimTypeIndTy.ByteTy;
    public static final PrimTypeIndTy ShortTy = PrimTypeIndTy.ShortTy;
    public static final PrimTypeIndTy IntTy = PrimTypeIndTy.IntTy;
    public static final PrimTypeIndTy LongTy = PrimTypeIndTy.LongTy;
    public static final OperationKindTy AddOp = OperationKindTy.AddOp;
    public static final OperationKindTy SubOp = OperationKindTy.SubOp;
    public static final OperationKindTy NegOp = OperationKindTy.NegOp;
    public static final OperationKindTy MulOp = OperationKindTy.MulOp;
    public static final OperationKindTy DivOp = OperationKindTy.DivOp;
    public static final OperationKindTy ExpOp = OperationKindTy.ExpOp;
    public static final byte MaxB = 127;
    public static final byte MinB = -128;
    public static final short MaxS = Short.MAX_VALUE;
    public static final short MinS = Short.MIN_VALUE;
    public static final int MaxI = Integer.MAX_VALUE;
    public static final int MinI = Integer.MIN_VALUE;
    public static final long MaxL = Long.MAX_VALUE;
    public static final long MinL = Long.MIN_VALUE;

    public static final byte add(byte L, byte R) {
        short result = (short)(L + R);
        if (result < -128 || result > 127) {
            throw new IllegalArithArgsException(ByteTy, AddOp, L, R);
        }
        return (byte)result;
    }

    public static final short add(short L, short R) {
        int result = L + R;
        if (result < Short.MIN_VALUE || result > Short.MAX_VALUE) {
            throw new IllegalArithArgsException(ShortTy, AddOp, L, R);
        }
        return (short)result;
    }

    public static final int add(int L, int R) {
        long result = (long)L + (long)R;
        if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
            throw new IllegalArithArgsException(IntTy, AddOp, L, R);
        }
        return (int)result;
    }

    public static final long add(long L, long R) {
        long result = L + R;
        if (L > 0L && R > 0L && result < 0L || L < 0L && R < 0L && result >= 0L) {
            throw new IllegalArithArgsException(LongTy, AddOp, L, R);
        }
        return result;
    }

    public static final byte sub(byte L, byte R) {
        short result = (short)(L - R);
        if (result < -128 || result > 127) {
            throw new IllegalArithArgsException(ByteTy, AddOp, L, R);
        }
        return (byte)result;
    }

    public static final short sub(short L, short R) {
        int result = L - R;
        if (result < Short.MIN_VALUE || result > Short.MAX_VALUE) {
            throw new IllegalArithArgsException(ShortTy, AddOp, L, R);
        }
        return (short)result;
    }

    public static final int sub(int L, int R) {
        long result = (long)L - (long)R;
        if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
            throw new IllegalArithArgsException(IntTy, AddOp, L, R);
        }
        return (int)result;
    }

    public static final long sub(long L, long R) {
        long result = L - R;
        if (L >= 0L && R < 0L && result < 0L || L < 0L && R > 0L && result > 0L) {
            throw new IllegalArithArgsException(LongTy, SubOp, L, R);
        }
        return result;
    }

    public static final byte neg(byte L) {
        if (L == -128) {
            throw new IllegalArithArgsException(ByteTy, NegOp, L);
        }
        return -L;
    }

    public static final short neg(short L) {
        if (L == Short.MIN_VALUE) {
            throw new IllegalArithArgsException(ShortTy, NegOp, L);
        }
        return -L;
    }

    public static final int neg(int L) {
        if (L == Integer.MIN_VALUE) {
            throw new IllegalArithArgsException(IntTy, NegOp, L);
        }
        return -L;
    }

    public static final long neg(long L) {
        if (L == Long.MIN_VALUE) {
            throw new IllegalArithArgsException(LongTy, NegOp, L);
        }
        return -L;
    }

    public static final byte mul(byte L, byte R) {
        short result = (short)(L * R);
        if (result < -128 || result > 127) {
            throw new IllegalArithArgsException(ByteTy, AddOp, L, R);
        }
        return (byte)result;
    }

    public static final short mul(short L, short R) {
        int result = L * R;
        if (result < Short.MIN_VALUE || result > Short.MAX_VALUE) {
            throw new IllegalArithArgsException(ShortTy, AddOp, L, R);
        }
        return (short)result;
    }

    public static final int mul(int L, int R) {
        long result = (long)L * (long)R;
        if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
            throw new IllegalArithArgsException(IntTy, AddOp, L, R);
        }
        return (int)result;
    }

    public static final long mul(long L, long R) {
        if (L > 0L && (R < Long.MIN_VALUE / L || R > Long.MAX_VALUE / L) || L == -1L && R == Long.MIN_VALUE || L < -1L && (R < Long.MAX_VALUE / L || R > Long.MIN_VALUE / L)) {
            throw new IllegalArithArgsException(LongTy, MulOp, L, R);
        }
        return L * R;
    }

    public static final byte div(byte L, byte R) {
        if (L == -128 && R == -1) {
            throw new IllegalArithArgsException(ByteTy, DivOp, L, R);
        }
        return (byte)(L / R);
    }

    public static final short div(short L, short R) {
        if (L == Short.MIN_VALUE && R == -1) {
            throw new IllegalArithArgsException(ShortTy, DivOp, L, R);
        }
        return (short)(L / R);
    }

    public static final int div(int L, int R) {
        if (L == Integer.MIN_VALUE && R == -1) {
            throw new IllegalArithArgsException(IntTy, DivOp, L, R);
        }
        return L / R;
    }

    public static final long div(long L, long R) {
        if (L == Long.MIN_VALUE && R == -1L) {
            throw new IllegalArithArgsException(LongTy, DivOp, L, R);
        }
        return L / R;
    }

    public static byte exp(byte L, byte R) {
        if (L == 0 && R < 0) {
            throw new IllegalArithArgsException(ByteTy, ExpOp, L, R);
        }
        if ((L >= 2 || L <= -2) && R > 0) {
            short ExpVal = 1;
            for (byte i = 1; i <= R; i = (byte)(i + 1)) {
                if ((ExpVal = (short)(ExpVal * L)) <= 127 && ExpVal >= -128) continue;
                throw new IllegalArithArgsException(ByteTy, ExpOp, L, R);
            }
            return (byte)ExpVal;
        }
        return (byte)StrictMath.pow(L, R);
    }

    public static short exp(short L, short R) {
        if (L == 0 && R < 0) {
            throw new IllegalArithArgsException(ShortTy, ExpOp, L, R);
        }
        if ((L >= 2 || L <= -2) && R > 0) {
            int ExpVal = 1;
            for (short i = 1; i <= R; i = (short)((byte)(i + 1))) {
                if ((ExpVal *= L) <= Short.MAX_VALUE && ExpVal >= Short.MIN_VALUE) continue;
                throw new IllegalArithArgsException(ShortTy, ExpOp, L, R);
            }
            return (short)ExpVal;
        }
        return (short)StrictMath.pow(L, R);
    }

    public static int exp(int L, int R) {
        if (L == 0 && R < 0) {
            throw new IllegalArithArgsException(IntTy, ExpOp, L, R);
        }
        if ((L >= 2 || L <= -2) && R > 0) {
            long ExpVal = 1L;
            for (int i = 1; i <= R; i = (int)((byte)(i + 1))) {
                if ((ExpVal *= (long)L) <= Integer.MAX_VALUE && ExpVal >= Integer.MIN_VALUE) continue;
                throw new IllegalArithArgsException(IntTy, ExpOp, L, R);
            }
            return (int)ExpVal;
        }
        return (int)StrictMath.pow(L, R);
    }

    public static long exp(long L, long R) {
        if (L == 0L && R < 0L) {
            throw new IllegalArithArgsException(LongTy, ExpOp, L, R);
        }
        if ((L >= 2L || L <= -2L) && R > 0L) {
            double ExpVal = 1.0;
            double DL = L;
            double DMaxL = 9.223372036854776E18;
            double DMinL = -9.223372036854776E18;
            int i = 1;
            while ((long)i <= R) {
                if ((ExpVal *= DL) >= DMaxL || ExpVal < DMinL) {
                    throw new IllegalArithArgsException(LongTy, ExpOp, L, R);
                }
                i = (byte)(i + 1);
            }
        }
        if (R == 0L) {
            return 1L;
        }
        if (R == 1L) {
            return L;
        }
        if (L == 0L && R > 0L) {
            return 0L;
        }
        if (L == 1L) {
            return 1L;
        }
        if (L == -1L) {
            return R % 2L == 0L ? 1 : -1;
        }
        if (R < 0L) {
            return 1L / SafeIntegerArithmetic.exp(L, -R);
        }
        long res = 1L;
        int i = 1;
        while ((long)i <= R) {
            res *= L;
            i = (byte)(i + 1);
        }
        return res;
    }

    public static class IllegalArithArgsException
    extends IllegalArgumentException {
        protected PrimTypeIndTy typeIndication;
        protected OperationKindTy operationKind;
        protected long L;
        protected long R;

        public IllegalArithArgsException(PrimTypeIndTy type2, OperationKindTy operation, long L, long R) {
            this.typeIndication = type2;
            this.operationKind = operation;
            this.L = L;
            this.R = R;
            System.out.println("illegal args: op = " + this.operationKind.getV() + ", type = " + this.typeIndication.getVal() + ", L = " + L + ", R = " + R);
        }

        public IllegalArithArgsException(PrimTypeIndTy type2, OperationKindTy operation, long L) {
            this.typeIndication = type2;
            this.operationKind = operation;
            this.L = L;
            System.out.println("illegal args: op = " + this.operationKind.getV() + ", type = " + this.typeIndication.getVal() + ", L = " + L);
        }

        public PrimTypeIndTy getType() {
            return this.typeIndication;
        }

        public OperationKindTy getOperation() {
            return this.operationKind;
        }

        public long getLeftOp() {
            return this.L;
        }

        public long getRightOp() {
            return this.R;
        }
    }

    public static final class OperationKindTy {
        protected static final OperationKindTy AddOp = new OperationKindTy("AddOp");
        protected static final OperationKindTy SubOp = new OperationKindTy("SubOp");
        protected static final OperationKindTy NegOp = new OperationKindTy("NegOp");
        protected static final OperationKindTy MulOp = new OperationKindTy("MulOp");
        protected static final OperationKindTy DivOp = new OperationKindTy("DivOp");
        protected static final OperationKindTy ExpOp = new OperationKindTy("ExpOp");
        private String v;

        public String getV() {
            return this.v;
        }

        private OperationKindTy(String Val) {
            this.v = Val;
        }
    }

    public static final class PrimTypeIndTy {
        protected static final PrimTypeIndTy ByteTy = new PrimTypeIndTy("ByteTy");
        protected static final PrimTypeIndTy ShortTy = new PrimTypeIndTy("ShortTy");
        protected static final PrimTypeIndTy IntTy = new PrimTypeIndTy("IntTy");
        protected static final PrimTypeIndTy LongTy = new PrimTypeIndTy("LongTy");
        private String Val;

        public String getVal() {
            return this.Val;
        }

        private PrimTypeIndTy(String Val) {
            this.Val = Val;
        }
    }
}

