/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.range;

import com.davidsoergel.dsutils.range.Interval;
import com.davidsoergel.dsutils.range.SerializableRange;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleIntervalRange
implements Interval<Double>,
SerializableRange<Double> {
    private static final Logger logger = Logger.getLogger(DoubleIntervalRange.class);
    final Double min;
    final Double max;
    final boolean closedLeft;
    final boolean closedRight;

    public DoubleIntervalRange(Double min, Double max, boolean closedLeft, boolean closedRight) {
        this.closedLeft = closedLeft;
        this.closedRight = closedRight;
        this.max = max;
        this.min = min;
    }

    @Override
    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    @Override
    public boolean isClosedRight() {
        return this.closedRight;
    }

    @Override
    public Double getMax() {
        return this.max;
    }

    @Override
    public Double getMin() {
        return this.min;
    }

    public String toString() {
        return String.format((this.closedLeft ? "[" : "(") + "%g,%g" + (this.closedRight ? "]" : ")"), this.min, this.max);
    }

    @Override
    public int compareTo(Interval<Double> o) {
        int result = this.min.compareTo(o.getMin());
        if (result == 0) {
            if (this.closedLeft && !o.isClosedLeft()) {
                result = -1;
            } else if (!this.closedLeft && o.isClosedLeft()) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public boolean encompassesValue(Double value) {
        boolean leftOK = this.min < value || this.closedLeft && this.min.equals(value);
        boolean rightOK = this.max > value || this.closedRight && this.max.equals(value);
        return leftOK && rightOK;
    }

    public int size() {
        return 1;
    }
}

