/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.range;

import com.davidsoergel.dsutils.math.MathUtils;
import com.davidsoergel.dsutils.range.BasicSteppedRange;
import com.davidsoergel.dsutils.range.IntegerSetRange;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerSteppedRange
extends BasicSteppedRange<Integer> {
    public IntegerSteppedRange(Integer min, Integer max, Integer step) {
        super(min, max, step);
    }

    protected IntegerSetRange asSetRange() {
        return new IntegerSetRange(this.getValues());
    }

    @Override
    public boolean encompassesValue(Integer value) {
        assert (this.step != null);
        assert ((Integer)this.step != 0);
        Integer multiplier = (value - (Integer)this.min) / (Integer)this.step;
        return MathUtils.equalWithinFPError(multiplier.intValue(), Math.floor(multiplier.intValue()));
    }

    @Override
    public SortedSet<Integer> getValues() {
        assert (this.step != null);
        assert ((Integer)this.step != 0);
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (int d = ((Integer)this.min).intValue(); d <= (Integer)this.max; d += ((Integer)this.step).intValue()) {
            result.add(d);
        }
        return result;
    }

    @Override
    public int size() {
        assert (this.step != null);
        assert ((Integer)this.step != 0);
        return ((Integer)this.max - (Integer)this.min) / (Integer)this.step;
    }
}

