/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.range;

import com.davidsoergel.dsutils.range.BasicInterval;
import com.davidsoergel.dsutils.range.Interval;
import com.davidsoergel.dsutils.range.MultiIntervalUnion;
import com.davidsoergel.dsutils.range.MutableBasicInterval;
import com.google.common.collect.HashMultiset;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiIntervalIntersection<T extends Number>
extends TreeSet<Interval<T>> {
    private static final Logger logger = Logger.getLogger(MultiIntervalIntersection.class);

    /*
     * WARNING - void declaration
     */
    public <U extends Interval<T>> MultiIntervalIntersection(Set<Set<U>> possiblyOverlappingIntervalSets) {
        HashSet intervalSets = new HashSet();
        for (Set<U> intervalSet : possiblyOverlappingIntervalSets) {
            intervalSets.add(new MultiIntervalUnion(intervalSet));
        }
        TreeMap fullLeftRightMap = new TreeMap();
        HashSet excludedEndpoints = new HashSet();
        HashMultiset<Number> includedEndpoints = HashMultiset.create();
        int numberOfConstraints = intervalSets.size();
        for (Set set : intervalSets) {
            for (Interval i : set) {
                Object left = i.getMin();
                Object right = i.getMax();
                Integer leftCount = (Integer)fullLeftRightMap.get(left);
                fullLeftRightMap.put(left, leftCount == null ? 1 : leftCount + 1);
                Integer rightCount = (Integer)fullLeftRightMap.get(right);
                fullLeftRightMap.put(right, rightCount == null ? -1 : rightCount - 1);
                if (i.isClosedLeft()) {
                    includedEndpoints.add((Number)left);
                } else {
                    excludedEndpoints.add(left);
                }
                if (i.isClosedRight()) {
                    includedEndpoints.add((Number)right);
                    continue;
                }
                excludedEndpoints.add(right);
            }
        }
        int openParens = 0;
        Object var8_10 = null;
        for (Number position : fullLeftRightMap.keySet()) {
            void var8_11;
            int parenDelta = (Integer)fullLeftRightMap.get(position);
            if (parenDelta != 0) {
                openParens += parenDelta;
                if (var8_11 == null) {
                    if (openParens != numberOfConstraints) continue;
                    MutableBasicInterval<Number> mutableBasicInterval = new MutableBasicInterval<Number>();
                    mutableBasicInterval.setLeft(position);
                    mutableBasicInterval.setClosedLeft(!excludedEndpoints.contains(position));
                    continue;
                }
                assert (openParens < numberOfConstraints);
                var8_11.setRight(position);
                var8_11.setClosedRight(!excludedEndpoints.contains(position));
                this.add(var8_11);
                Object var8_13 = null;
                continue;
            }
            if (includedEndpoints.contains(position)) continue;
            assert (var8_11 != null);
            var8_11.setRight(position);
            var8_11.setClosedRight(false);
            this.add(var8_11);
            MutableBasicInterval<Number> mutableBasicInterval = new MutableBasicInterval<Number>();
            mutableBasicInterval.setLeft(position);
            mutableBasicInterval.setClosedLeft(false);
        }
        assert (openParens == 0);
        for (Number position : includedEndpoints) {
            if (includedEndpoints.count(position) != numberOfConstraints || this.encompassesValue(position)) continue;
            MutableBasicInterval<Number> mutableBasicInterval = new MutableBasicInterval<Number>();
            mutableBasicInterval.setLeft(position);
            mutableBasicInterval.setClosedLeft(true);
            mutableBasicInterval.setRight(position);
            mutableBasicInterval.setClosedRight(true);
            this.add(mutableBasicInterval);
        }
    }

    public final boolean encompassesValue(T value) {
        try {
            Interval f = this.headSet(new BasicInterval<T>(value, value, false, false)).last();
            return f.encompassesValue(value);
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }
}

