/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.range;

import com.davidsoergel.dsutils.range.BasicInterval;
import com.davidsoergel.dsutils.range.Interval;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableBasicInterval<T extends Number>
implements Interval<T> {
    private static final Logger logger = Logger.getLogger(MutableBasicInterval.class);
    protected T left;
    protected T right;
    boolean closedLeft;
    boolean closedRight;

    public BasicInterval<T> build() {
        return new BasicInterval<T>(this.left, this.right, this.closedLeft, this.closedRight);
    }

    @Override
    public int compareTo(Interval<T> o) {
        int result = ((Comparable)this.getMin()).compareTo(o.getMin());
        if (result == 0) {
            if (this.closedLeft && !o.isClosedLeft()) {
                result = -1;
            } else if (!this.closedLeft && o.isClosedLeft()) {
                result = 1;
            }
        }
        return result;
    }

    public void setLeft(T left) {
        this.left = left;
    }

    public void setRight(T right) {
        this.right = right;
    }

    public void setClosedRight(boolean closedRight) {
        this.closedRight = closedRight;
    }

    public void setClosedLeft(boolean closedLeft) {
        this.closedLeft = closedLeft;
    }

    @Override
    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    @Override
    public boolean isClosedRight() {
        return this.closedRight;
    }

    @Override
    public T getMax() {
        return this.right;
    }

    @Override
    public T getMin() {
        return this.left;
    }

    @Override
    public boolean encompassesValue(T value) {
        int leftCompare = ((Comparable)this.left).compareTo(value);
        int rightCompare = ((Comparable)this.right).compareTo(value);
        if (this.closedLeft && leftCompare == 0) {
            return true;
        }
        if (this.closedRight && rightCompare == 0) {
            return true;
        }
        return leftCompare < 0 && rightCompare > 0;
    }
}

