/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.range;

import com.davidsoergel.dsutils.collections.DSCollectionUtils;
import com.davidsoergel.dsutils.range.BasicSetRange;
import com.davidsoergel.dsutils.range.BooleanSetRange;
import com.davidsoergel.dsutils.range.DoubleSetRange;
import com.davidsoergel.dsutils.range.IntegerSetRange;
import com.davidsoergel.dsutils.range.RangeRuntimeException;
import com.davidsoergel.dsutils.range.SerializableRange;
import com.davidsoergel.dsutils.range.StringSetRange;
import com.davidsoergel.dsutils.range.URLSetRange;
import java.net.URL;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeFactory {
    public static SerializableRange<?> createBasicSetRange(Object val) {
        BasicSetRange result;
        if (val instanceof Boolean) {
            result = new BooleanSetRange((Collection<Boolean>)DSCollectionUtils.setOf((Boolean)val));
        } else if (val instanceof Double) {
            result = new DoubleSetRange((Collection<Double>)DSCollectionUtils.setOf((Double)val));
        } else if (val instanceof Integer) {
            result = new IntegerSetRange((Collection<Integer>)DSCollectionUtils.setOf((Integer)val));
        } else if (val instanceof String) {
            result = new StringSetRange((Collection<String>)DSCollectionUtils.setOf((String)val));
        } else if (val instanceof URL) {
            result = new URLSetRange(DSCollectionUtils.setOf((URL)val));
        } else {
            throw new RangeRuntimeException("Can't make a range of type " + val.getClass());
        }
        return result;
    }
}

