/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.range;

import com.davidsoergel.dsutils.EnumValue;
import com.davidsoergel.dsutils.range.BasicSetRange;
import com.davidsoergel.dsutils.range.RangeRuntimeException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLSetRange
extends BasicSetRange<URL> {
    private static final Logger logger = Logger.getLogger(URLSetRange.class);

    protected URLSetRange() {
    }

    public URLSetRange(Collection urlValues) {
        super(new HashSet());
        for (Object s : urlValues) {
            if (s instanceof String) {
                try {
                    this.values.add(new URL((String)s));
                    continue;
                }
                catch (MalformedURLException e) {
                    logger.error("Error", e);
                    throw new RangeRuntimeException(e);
                }
            }
            if (s instanceof EnumValue) {
                this.values.add((URL)s);
                continue;
            }
            throw new RangeRuntimeException("EnumSetRange must be initialized with EnumValues or Strings, not " + s.getClass());
        }
    }

    protected URLSetRange create(Collection<URL> values) {
        return new URLSetRange(values);
    }

    public Set<String> getStringValues() {
        HashSet<String> result = new HashSet<String>();
        for (URL value : this.values) {
            result.add(value.toString());
        }
        return result;
    }
}

