/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.stringmapper;

import com.davidsoergel.dsutils.DSStringUtils;
import com.davidsoergel.dsutils.stringmapper.StringMapper;
import com.davidsoergel.dsutils.stringmapper.StringMapperException;
import com.davidsoergel.dsutils.stringmapper.TypedValueStringMapper;
import java.lang.reflect.Type;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanArrayMapper
extends StringMapper<Boolean[]> {
    @Override
    public Type[] basicTypes() {
        return new Type[]{Boolean[].class};
    }

    @Override
    public Boolean[] parse(String s) throws StringMapperException {
        if (s == null || s.trim().equals("")) {
            return null;
        }
        ArrayList result = new ArrayList();
        StringMapper booleanMapper = TypedValueStringMapper.get(Boolean.class);
        for (String d : s.split(":")) {
            result.add(booleanMapper.parse(d));
        }
        return result.toArray(new Boolean[0]);
    }

    @Override
    public String render(Boolean[] value) {
        return DSStringUtils.join((Object[])value, ":");
    }
}

