/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.stringmapper;

import com.davidsoergel.dsutils.SubclassFinder;
import com.davidsoergel.dsutils.TypeUtils;
import com.davidsoergel.dsutils.increment.BasicIncrementor;
import com.davidsoergel.dsutils.increment.Incrementor;
import com.davidsoergel.dsutils.stringmapper.StringMapper;
import com.davidsoergel.dsutils.stringmapper.StringMapperException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedValueStringMapper
extends HashMap<Type, StringMapper> {
    private static final Logger logger = Logger.getLogger(TypedValueStringMapper.class);
    static TypedValueStringMapper _instance = new TypedValueStringMapper().init();

    public static StringMapper get(Type c) throws StringMapperException {
        StringMapper stringMapper = (StringMapper)_instance.get(c);
        if (stringMapper == null) {
            for (Type t : _instance.keySet()) {
                if (!TypeUtils.isAssignableFrom(t, c)) continue;
                stringMapper = (StringMapper)_instance.get(t);
                break;
            }
        }
        if (stringMapper == null) {
            stringMapper = (StringMapper)_instance.get(Class.class);
        }
        return stringMapper;
    }

    public static StringMapper register(Type k, StringMapper v) {
        return _instance.put(k, v);
    }

    public TypedValueStringMapper init() {
        try {
            for (Class c : SubclassFinder.find("com.davidsoergel.dsutils.stringmapper", StringMapper.class, (Incrementor)new BasicIncrementor(null, null))) {
                if (c.equals(StringMapper.class) || !TypeUtils.isAssignableFrom(StringMapper.class, c)) continue;
                StringMapper sm = (StringMapper)c.newInstance();
                for (Type t : sm.basicTypes()) {
                    this.put(t, sm);
                }
            }
        }
        catch (IllegalAccessException e) {
            logger.error("Error", e);
            throw new Error(e);
        }
        catch (InstantiationException e) {
            logger.error("Error", e);
            throw new Error(e);
        }
        catch (IOException e) {
            logger.error("Error", e);
            throw new Error(e);
        }
        return this;
    }

    public static Object parse(Type type2, String s) throws StringMapperException {
        if (type2 instanceof Class && ((Class)type2).isEnum()) {
            Object result = Enum.valueOf((Class)type2, s);
            if (result == null) {
                throw new StringMapperException("Enum value " + s + " does not exist in" + type2);
            }
            return result;
        }
        StringMapper sm = TypedValueStringMapper.get(type2);
        if (sm != null) {
            return sm.parse(s);
        }
        Class c = (Class)TypedValueStringMapper.get(Class.class).parse(s);
        if (TypeUtils.isAssignableFrom(type2, c)) {
            return c;
        }
        throw new StringMapperException("Don't know how to parse a string into type " + type2);
    }
}

