/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.swing;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;

public class SortedListModel
extends AbstractListModel
implements Iterable {
    SortedSet<Object> model = new TreeSet<Object>();

    public int getSize() {
        return this.model.size();
    }

    public Object getElementAt(int index) {
        return this.model.toArray()[index];
    }

    public void add(Object element) {
        if (this.model.add(element)) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    public void addAll(Object[] elements) {
        List<Object> c = Arrays.asList(elements);
        this.model.addAll(c);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void clear() {
        this.model.clear();
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public boolean contains(Object element) {
        return this.model.contains(element);
    }

    public Object firstElement() {
        return this.model.first();
    }

    public Iterator iterator() {
        return this.model.iterator();
    }

    public Object lastElement() {
        return this.model.last();
    }

    public boolean removeElement(Object element) {
        boolean removed = this.model.remove(element);
        if (removed) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
        return removed;
    }
}

