/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.swing.jmultiprogressbar;

import com.davidsoergel.dsutils.increment.Incrementor;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class JMultiProgressBar
extends JPanel
implements Incrementor.Listener {
    Map<Integer, JProgressBar> theBars = new HashMap<Integer, JProgressBar>();
    Map<Integer, JLabel> theLabels = new HashMap<Integer, JLabel>();

    public JMultiProgressBar() {
        this.setLayout(new BoxLayout(this, 3));
        Dimension oneBar = new JProgressBar().getPreferredSize();
        this.setPreferredSize(new Dimension(500, (int)oneBar.getHeight() * 6));
    }

    private void remove(Integer id) {
        JProgressBar bar = this.theBars.get(id);
        JLabel label = this.theLabels.get(id);
        if (bar != null) {
            this.remove(bar);
        }
        if (label != null) {
            this.remove(label);
        }
    }

    public void incrementableDone(final Incrementor.IncrementorDoneEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Integer id = e.getId();
                JMultiProgressBar.this.remove(id);
                JMultiProgressBar.this.revalidate();
                JMultiProgressBar.this.repaint();
            }
        });
    }

    public void incrementableNoteUpdated(final Incrementor.IncrementorNoteEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Integer id = e.getId();
                JLabel label = JMultiProgressBar.this.theLabels.get(id);
                if (label == null) {
                    JMultiProgressBar.this.createBar(id);
                    label = JMultiProgressBar.this.theLabels.get(id);
                }
                label.setText(e.getClientName() + " : " + e.getNote());
            }
        });
    }

    public void incrementableProgressUpdated(final Incrementor.IncrementorProgressEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Integer id = e.getId();
                JProgressBar bar = JMultiProgressBar.this.theBars.get(id);
                if (bar == null) {
                    JMultiProgressBar.this.createBar(id);
                    bar = JMultiProgressBar.this.theBars.get(id);
                }
                int percent = e.getPercent();
                bar.setValue(percent);
                bar.setIndeterminate(percent == 0);
            }
        });
    }

    private void createBar(Integer id) {
        JLabel label = new JLabel("");
        this.theLabels.put(id, label);
        this.add(label);
        JProgressBar bar = new JProgressBar(0, 100);
        this.theBars.put(id, bar);
        this.add(bar);
        this.revalidate();
        this.repaint();
    }

    public int compareTo(Object o) {
        return new Integer(this.hashCode()).compareTo(o.hashCode());
    }
}

