/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.swing.jmultiprogressbar;

import com.davidsoergel.dsutils.swing.jmultiprogressbar.JMultiProgressBar;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class JMultiProgressBarFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(JMultiProgressBarFrame.class);
    private JMultiProgressBar monitor;
    private static JMultiProgressBarFrame _instance;

    public static void setInstance(JMultiProgressBarFrame instance) {
        _instance = instance;
    }

    public static JMultiProgressBarFrame getInstance() {
        if (_instance == null) {
            JMultiProgressBarFrame.initInstanceOnEDT();
        }
        return _instance;
    }

    private static void initInstanceOnEDT() {
        if (SwingUtilities.isEventDispatchThread()) {
            _instance = new JMultiProgressBarFrame();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        _instance = new JMultiProgressBarFrame();
                    }
                });
            }
            catch (InterruptedException e) {
                logger.error("Error", e);
                throw new Error(e);
            }
            catch (InvocationTargetException e) {
                logger.error("Error", e);
                throw new Error(e);
            }
        }
    }

    public static JMultiProgressBar getInstanceMonitor() {
        return JMultiProgressBarFrame.getInstance().getMonitor();
    }

    public JMultiProgressBarFrame() throws HeadlessException {
        this.setLocationByPlatform(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.monitor = new JMultiProgressBar();
        JScrollPane scroller = new JScrollPane(this.monitor);
        scroller.setVerticalScrollBarPolicy(20);
        scroller.setHorizontalScrollBarPolicy(31);
        this.add(scroller);
        this.setDefaultCloseOperation(1);
        this.pack();
        this.validate();
        this.setLocation(0, (int)dimension.getHeight() - this.getHeight() - 40);
        this.setTitle("Jandy Status");
        this.setVisible(true);
    }

    public JMultiProgressBar getMonitor() {
        return this.monitor;
    }
}

