/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.runutils;

import com.davidsoergel.runutils.JsapResultToMapAdapter;
import com.davidsoergel.runutils.PropsException;
import com.davidsoergel.trees.htpn.ExtendedHierarchicalTypedPropertyNode;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.defaultsources.PropertyDefaultSource;
import java.awt.Color;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsapUtility {
    private static final Logger logger = Logger.getLogger(JsapUtility.class);
    private SimpleJSAP jsap = null;
    private JSAPResult jsapResult;
    private String programName;
    private String programDescription;
    private String defaultsFilename;
    private Set<ExtendedHierarchicalTypedPropertyNode> theDesiredProperties = new HashSet<ExtendedHierarchicalTypedPropertyNode>();

    public JsapUtility(String programName, String programDescription, String defaultsFilename) {
        this.programName = programName;
        this.programDescription = programDescription;
        this.defaultsFilename = defaultsFilename;
    }

    public Map<String, Object> getMap() {
        return new JsapResultToMapAdapter(this.jsap, this.jsapResult);
    }

    public void parseCommandLine(String[] argv) throws PropsException {
        LinkedList<Parameter> paramList = new LinkedList<Parameter>();
        for (ExtendedHierarchicalTypedPropertyNode p : this.theDesiredProperties) {
            paramList.add(this.getJSAPParameter(p));
        }
        try {
            this.jsap = new SimpleJSAP(this.programName, this.programDescription, paramList.toArray(new Parameter[0]));
        }
        catch (JSAPException e) {
            logger.error("Error", e);
            logger.warn("" + this.jsap.getUsage() + "\n" + this.jsap.getHelp());
        }
        this.jsap.registerDefaultSource(new PropertyDefaultSource(this.defaultsFilename, false));
        JSAPResult tmp = this.jsap.parse(argv);
        if (this.jsap.messagePrinted()) {
            System.exit(1);
        }
        this.setJSAPResult(tmp);
    }

    public Parameter getJSAPParameter(ExtendedHierarchicalTypedPropertyNode<String, Object, ?> node) throws PropsException {
        Type type2 = node.getType();
        String name = (String)node.getKey();
        String helpmessage = node.getHelpmessage();
        if (type2 == Boolean.class) {
            return new Switch(name, '\u0000', name, helpmessage);
        }
        if (type2 == String[].class) {
            UnflaggedOption tmp = new UnflaggedOption(name, JSAP.STRING_PARSER, null, false, true, helpmessage);
            tmp.setList(true);
            return tmp;
        }
        if (type2 == Double[].class) {
            return new FlaggedOption(name, JSAP.STRING_PARSER, null, false, '\u0000', name, helpmessage);
        }
        try {
            StringParser parser2 = JsapUtility.getJSAPParserForClass((Class)type2);
            if (parser2 == null) {
                throw new PropsException("Requested property " + name + " of unknown class: " + type2);
            }
            return new FlaggedOption(name, parser2, null, false, '\u0000', name, helpmessage);
        }
        catch (ClassCastException e) {
            throw new PropsException("Can't create a JSAP parameter definition for a field of generic type.");
        }
    }

    private static StringParser getJSAPParserForClass(Class c) {
        if (c == BigDecimal.class) {
            return JSAP.BIGDECIMAL_PARSER;
        }
        if (c == BigInteger.class) {
            return JSAP.BIGINTEGER_PARSER;
        }
        if (c == Boolean.class) {
            return JSAP.BOOLEAN_PARSER;
        }
        if (c == Byte.class) {
            return JSAP.BYTE_PARSER;
        }
        if (c == Character.class) {
            return JSAP.CHARACTER_PARSER;
        }
        if (c == Class.class) {
            return JSAP.CLASS_PARSER;
        }
        if (c == Color.class) {
            return JSAP.COLOR_PARSER;
        }
        if (c == Double.class) {
            return JSAP.DOUBLE_PARSER;
        }
        if (c == Float.class) {
            return JSAP.FLOAT_PARSER;
        }
        if (c == InetAddress.class) {
            return JSAP.INETADDRESS_PARSER;
        }
        if (c == Integer.class) {
            return JSAP.INTEGER_PARSER;
        }
        if (c == Long.class) {
            return JSAP.LONG_PARSER;
        }
        if (c == Package.class) {
            return JSAP.PACKAGE_PARSER;
        }
        if (c == Short.class) {
            return JSAP.SHORT_PARSER;
        }
        if (c == String.class) {
            return JSAP.STRING_PARSER;
        }
        if (c == URL.class) {
            return JSAP.URL_PARSER;
        }
        return null;
    }

    private void setJSAPResult(JSAPResult jsapResult) {
        this.jsapResult = jsapResult;
    }
}

