/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.runutils;

import com.davidsoergel.dsutils.GenericFactory;
import com.davidsoergel.dsutils.SubclassFinder;
import com.davidsoergel.dsutils.increment.Incrementor;
import com.davidsoergel.dsutils.stringmapper.TypedValueStringMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.map.ListOrderedMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginMap<V>
extends ListOrderedMap<String, V> {
    private static final Logger logger = Logger.getLogger(PluginMap.class);
    public List<String> packageNames = new ArrayList<String>();
    String defaultString = null;
    private String interfaceName;
    V defaultValue = null;
    private Map<Class, GenericFactory> theFactories = new HashMap<Class, GenericFactory>();
    private ClassLoader classLoader;

    public PluginMap(String[] packageNames, String interfaceName, String defaultString, ClassLoader classLoader, Incrementor incrementor) {
        this.interfaceName = interfaceName;
        this.defaultString = defaultString;
        this.classLoader = classLoader;
        for (String s : packageNames) {
            this.registerPackage(s, incrementor);
        }
    }

    public int indexOf(String s) {
        return this.asList().indexOf(s);
    }

    public V getValue(Class key) {
        return this.get(key.getCanonicalName());
    }

    public GenericFactory getFactory(Class key) {
        return this.theFactories.get(key);
    }

    private void registerPackage(String packageName, Incrementor incrementor) {
        this.packageNames.add(packageName);
        Type theInterface = this.getInterfaceType();
        if (theInterface != null) {
            try {
                for (Class c : SubclassFinder.find(packageName, theInterface, incrementor)) {
                    this.put(c.getCanonicalName(), this.defaultValue);
                }
            }
            catch (IOException e) {
                logger.error("Error", e);
                throw new Error(e);
            }
        }
    }

    public String getPluginName(int index) {
        return (String)this.asList().get(index);
    }

    public Class getPlugin(int index) throws ClassNotFoundException {
        String className = (String)this.asList().get(index);
        return Class.forName(className, true, this.classLoader);
    }

    @Override
    public V getValue(int index) {
        String className = (String)this.asList().get(index);
        return this.get(className);
    }

    public String getValueString(int index) {
        return TypedValueStringMapper.get(this.getValueType()).render(this.getValue(index));
    }

    private Type getValueType() {
        return this.getClass().getTypeParameters()[0];
    }

    public Type getInterfaceType() {
        try {
            return Class.forName(this.interfaceName, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Interface type not found: " + this.interfaceName);
            return null;
        }
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String className) {
        this.interfaceName = className;
    }

    public List<String> getPackageNames() {
        return this.packageNames;
    }

    public void setPackageNames(List<String> packageNames) {
        this.packageNames = packageNames;
    }

    public String getDefaultString() {
        return this.defaultString;
    }

    public void setDefaultString(String defaultString) {
        this.defaultString = defaultString;
    }

    public void putFactory(Class pluginClass, GenericFactory genericFactory) {
        this.theFactories.put(pluginClass, genericFactory);
    }

    public Set<Class> getAvailablePlugins() {
        return this.theFactories.keySet();
    }
}

