/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.runutils;

import com.davidsoergel.dsutils.PluginValue;
import com.davidsoergel.dsutils.collections.OrderedPair;
import com.davidsoergel.dsutils.stringmapper.StringMapperException;
import com.davidsoergel.dsutils.stringmapper.TypedValueStringMapper;
import com.davidsoergel.runutils.PropertyConsumerClassParser;
import com.davidsoergel.trees.htpn.AbstractExtendedHierarchicalTypedPropertyNode;
import com.davidsoergel.trees.htpn.HierarchicalPropertyNodeException;
import java.io.Serializable;
import java.util.HashSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyConsumerHTPN
extends AbstractExtendedHierarchicalTypedPropertyNode<String, Serializable, PropertyConsumerHTPN> {
    private static final Logger logger = Logger.getLogger(PropertyConsumerHTPN.class);

    @Override
    public void setValue(Serializable newValue) {
        if (!this.valueEquals(newValue)) {
            this.obsoleteChildren();
            super.setValue(newValue);
            Serializable value = (Serializable)this.getValue();
            this.updateTypeIfNeeded(value);
            try {
                this.updatePluginChildNodes();
            }
            catch (HierarchicalPropertyNodeException e) {
                logger.error("Error", e);
                throw new Error(e);
            }
            this.setChanged(true);
        }
    }

    public void inheritValuesRecursive() throws HierarchicalPropertyNodeException {
        this.inheritValueIfNeeded();
        this.useDefaultValueIfNeeded();
        for (PropertyConsumerHTPN child : this.getChildren()) {
            child.inheritValuesRecursive();
        }
    }

    private void updatePluginChildNodes() throws HierarchicalPropertyNodeException {
        Serializable value = (Serializable)this.getValue();
        if (value instanceof PluginValue) {
            String s = value.toString();
            if (s == null) {
                this.setValue(null);
            } else {
                try {
                    try {
                        Class c = (Class)TypedValueStringMapper.get(Class.class).parse(s);
                        PropertyConsumerHTPN basicNode = PropertyConsumerClassParser.parseClass(s);
                        this.setValue((Serializable)basicNode.getValue());
                        this.setObsolete(false);
                        HashSet basicChildren = new HashSet(basicNode.getChildren());
                        for (PropertyConsumerHTPN child : basicChildren) {
                            String childKey = (String)child.getKey();
                            PropertyConsumerHTPN existingChild = (PropertyConsumerHTPN)this.getChild(childKey);
                            if (existingChild != null) {
                                child = existingChild;
                            } else {
                                child.setParent(this);
                            }
                            child.setChanged(true);
                            child.setObsolete(false);
                        }
                    }
                    catch (StringMapperException e) {
                        this.setObsolete(true);
                        this.obsoleteChildren();
                    }
                }
                catch (ClassNotFoundException e) {
                    this.setObsolete(true);
                    this.obsoleteChildren();
                }
            }
        }
    }

    @Override
    public PropertyConsumerHTPN newChild(OrderedPair<String, Serializable> payload) {
        PropertyConsumerHTPN result = new PropertyConsumerHTPN();
        result.setPayload(payload);
        result.setParent(this);
        return result;
    }
}

