/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.runutils;

import com.davidsoergel.dsutils.math.MersenneTwisterFast;
import com.davidsoergel.runutils.QueueableTask;
import com.davidsoergel.runutils.TaskQueue;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskQueueProcessorThread<T extends QueueableTask>
extends Thread {
    private static final Logger logger = Logger.getLogger(TaskQueueProcessorThread.class);
    private TaskQueue<T> theQueue;

    public TaskQueueProcessorThread(TaskQueue q, String name) {
        super(name);
        this.theQueue = q;
    }

    @Override
    public void run() {
        MersenneTwisterFast.init();
        while (true) {
            T current;
            if ((current = this.theQueue.poll()) == null) {
                if (this.theQueue.wantsToFinish()) break;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (current == null) continue;
            try {
                current.perform();
            }
            catch (Throwable e) {
                logger.error("Error", e);
                this.theQueue.notifyThreadFailed(e);
                return;
            }
        }
        logger.info(this.getName() + " Thread exiting...");
        this.theQueue.notifyThreadFinished();
    }
}

