/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.stats.Histogram1D;
import com.davidsoergel.stats.StatsException;
import org.apache.log4j.Logger;

public class FixedWidthHistogram1D
extends Histogram1D {
    private static final Logger logger = Logger.getLogger(FixedWidthHistogram1D.class);
    private double binWidth;
    private double halfBinWidth;

    public double getHalfBinWidth() {
        return this.halfBinWidth;
    }

    public FixedWidthHistogram1D(double from, double to, double binWidth) {
        super(from, to, (int)((to - from) / binWidth));
        this.halfBinWidth = binWidth / 2.0;
    }

    public FixedWidthHistogram1D(double from, double to, double binWidth, double[] data) {
        this(from, to, binWidth);
        for (double d : data) {
            this.add(d);
        }
    }

    public FixedWidthHistogram1D(double[] data, int numBins) {
        super(DSArrayUtils.min(data), DSArrayUtils.max(data), numBins);
        this.binWidth = (this.to - this.from) / (double)numBins;
        this.halfBinWidth = this.binWidth / 2.0;
        for (double d : data) {
            this.add(d);
        }
    }

    public FixedWidthHistogram1D(double[] data, double[] weights, int numBins) {
        super(DSArrayUtils.min(data), DSArrayUtils.max(data), numBins);
        this.binWidth = (this.to - this.from) / (double)numBins;
        this.halfBinWidth = this.binWidth / 2.0;
        for (int i = 0; i < data.length; ++i) {
            this.add(data[i], weights == null ? 1.0 : weights[i]);
        }
    }

    public int findBinNumber(double x) throws StatsException {
        if (x < this.from || x > this.to) {
            throw new StatsException("Requested number  " + x + " not in histogram range " + this.from + " - " + this.to);
        }
        int result = (int)((x - this.from) / this.binWidth);
        if (result == this.bins) {
            --result;
        }
        return result;
    }

    public double bottomOfBin(int bin) throws StatsException {
        if (bin < 0 || bin >= this.bins) {
            throw new StatsException("Requested bin " + bin + " not in histogram range 0 - " + (this.bins - 1));
        }
        return this.from + (double)bin * this.binWidth;
    }

    public double topOfBin(int bin) throws StatsException {
        if (bin < 0 || bin >= this.bins) {
            throw new StatsException("Requested bin " + bin + " not in histogram range 0 - " + (this.bins - 1));
        }
        return this.from + (double)(bin + 1) * this.binWidth;
    }
}

